/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.risk.center.api.common;

import cn.com.duiba.tuia.risk.center.api.common.OrderBy;
import cn.com.duiba.tuia.risk.center.api.common.Pageable;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageRequest
implements Pageable,
Serializable {
    private static final long serialVersionUID = 9078336764139449739L;
    public static final Integer DEFAULT_OFFSET = 0;
    public static final Integer DEFAULT_PAGE_SIZE = 200;
    private Integer offset;
    private Integer pageSize;
    private List<OrderBy> orderByList;

    public static PageRequest of(int offset, int size) {
        return PageRequest.of(offset, size, Collections.emptyList());
    }

    public static PageRequest of(int offset, int size, OrderBy orderBy) {
        return PageRequest.newPageRequest(offset, size, Collections.singletonList(orderBy));
    }

    public static PageRequest of(int offset, int size, List<OrderBy> orderByList) {
        return PageRequest.newPageRequest(offset, size, orderByList);
    }

    public static PageRequest of(int offset, int size, OrderBy.Direction direction, String ... columnNames) {
        return PageRequest.of(offset, size, OrderBy.by(direction, columnNames));
    }

    static PageRequest newPageRequest(int offset, int size, List<OrderBy> orderByList) {
        PageRequest pageRequest = new PageRequest();
        pageRequest.setOffset(offset);
        pageRequest.setPageSize(size);
        pageRequest.setOrderByList(orderByList);
        return pageRequest;
    }

    @Override
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    @Override
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setOrderByList(List<OrderBy> orderByList) {
        this.orderByList = orderByList;
    }

    @Override
    public List<OrderBy> getSort() {
        return this.orderByList;
    }

    public String toString() {
        return String.format("Page request [offset %d, size: %s]", this.getOffset(), this.getPageSize());
    }
}

