package cn.com.duiba.tuia.robot.center.api.domain.dos;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.format.annotation.DateTimeFormat;

@JsonIgnoreProperties({"handler", "fieldHandler"})
@EqualsAndHashCode
@Data
@AllArgsConstructor
@NoArgsConstructor
public abstract class BaseEntity implements Serializable {
    private static final long serialVersionUID = 1L;
    @TableId
    @ApiModelProperty(
            value = "唯一标识",
            hidden = true
    )
    private String id;
    @CreatedBy
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "创建者",
            hidden = true
    )
    private String createBy;
    @CreatedDate
    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "创建时间",
            hidden = true
    )
    private Date gmtCreate;

    @LastModifiedDate
    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @DateTimeFormat(
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    @TableField(
            fill = FieldFill.INSERT_UPDATE
    )
    @ApiModelProperty(
            value = "更新时间",
            hidden = true
    )
    private Date gmtModify;
    @TableField(
            fill = FieldFill.INSERT
    )
    @ApiModelProperty(
            value = "删除标志 true/false 删除/未删除",
            hidden = true
    )
    private Boolean deleteFlag;

    public String getId() {
        return this.id;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getGmtCreate() {
        return this.gmtCreate;
    }


    public Date getGmtModify() {
        return this.gmtModify;
    }

    public Boolean getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }


    @JsonFormat(
            timezone = "GMT+8",
            pattern = "yyyy-MM-dd HH:mm:ss"
    )
    public void setGmtModify(Date gmtModify) {
        this.gmtModify = gmtModify;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }


}
