package cn.com.duiba.tuia.robot.center.api.domain.dto;

import cn.com.duiba.tuia.robot.center.api.domain.enums.UserEnums;

import java.io.Serializable;

public class AuthUser implements Serializable {
    private static final long serialVersionUID = 582441893336003319L;
    private String username;
    private String nickName;
    private String face;
    private String id;
    private Boolean longTerm = false;
    private UserEnums role;
    private String storeId;
    private String clerkId;
    private String storeName;
    private Boolean isSuper = false;
    private String tenantId;

    public AuthUser(String username, String id, String nickName, String face, UserEnums role) {
        this.username = username;
        this.face = face;
        this.id = id;
        this.role = role;
        this.nickName = nickName;
    }

    public static AuthUser.AuthUserBuilder builder() {
        return new AuthUser.AuthUserBuilder();
    }

    public String getUsername() {
        return this.username;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getFace() {
        return this.face;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getLongTerm() {
        return this.longTerm;
    }

    public UserEnums getRole() {
        return this.role;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public String getClerkId() {
        return this.clerkId;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public Boolean getIsSuper() {
        return this.isSuper;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public void setFace(String face) {
        this.face = face;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLongTerm(Boolean longTerm) {
        this.longTerm = longTerm;
    }

    public void setRole(UserEnums role) {
        this.role = role;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public void setClerkId(String clerkId) {
        this.clerkId = clerkId;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public void setIsSuper(Boolean isSuper) {
        this.isSuper = isSuper;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        } else if (!(o instanceof AuthUser)) {
            return false;
        } else {
            AuthUser other = (AuthUser)o;
            if (!other.canEqual(this)) {
                return false;
            } else {
                label143: {
                    Object this$longTerm = this.getLongTerm();
                    Object other$longTerm = other.getLongTerm();
                    if (this$longTerm == null) {
                        if (other$longTerm == null) {
                            break label143;
                        }
                    } else if (this$longTerm.equals(other$longTerm)) {
                        break label143;
                    }

                    return false;
                }

                Object this$isSuper = this.getIsSuper();
                Object other$isSuper = other.getIsSuper();
                if (this$isSuper == null) {
                    if (other$isSuper != null) {
                        return false;
                    }
                } else if (!this$isSuper.equals(other$isSuper)) {
                    return false;
                }

                Object this$username = this.getUsername();
                Object other$username = other.getUsername();
                if (this$username == null) {
                    if (other$username != null) {
                        return false;
                    }
                } else if (!this$username.equals(other$username)) {
                    return false;
                }

                label122: {
                    Object this$nickName = this.getNickName();
                    Object other$nickName = other.getNickName();
                    if (this$nickName == null) {
                        if (other$nickName == null) {
                            break label122;
                        }
                    } else if (this$nickName.equals(other$nickName)) {
                        break label122;
                    }

                    return false;
                }

                label115: {
                    Object this$face = this.getFace();
                    Object other$face = other.getFace();
                    if (this$face == null) {
                        if (other$face == null) {
                            break label115;
                        }
                    } else if (this$face.equals(other$face)) {
                        break label115;
                    }

                    return false;
                }

                Object this$id = this.getId();
                Object other$id = other.getId();
                if (this$id == null) {
                    if (other$id != null) {
                        return false;
                    }
                } else if (!this$id.equals(other$id)) {
                    return false;
                }

                Object this$role = this.getRole();
                Object other$role = other.getRole();
                if (this$role == null) {
                    if (other$role != null) {
                        return false;
                    }
                } else if (!this$role.equals(other$role)) {
                    return false;
                }

                label94: {
                    Object this$storeId = this.getStoreId();
                    Object other$storeId = other.getStoreId();
                    if (this$storeId == null) {
                        if (other$storeId == null) {
                            break label94;
                        }
                    } else if (this$storeId.equals(other$storeId)) {
                        break label94;
                    }

                    return false;
                }

                label87: {
                    Object this$clerkId = this.getClerkId();
                    Object other$clerkId = other.getClerkId();
                    if (this$clerkId == null) {
                        if (other$clerkId == null) {
                            break label87;
                        }
                    } else if (this$clerkId.equals(other$clerkId)) {
                        break label87;
                    }

                    return false;
                }

                Object this$storeName = this.getStoreName();
                Object other$storeName = other.getStoreName();
                if (this$storeName == null) {
                    if (other$storeName != null) {
                        return false;
                    }
                } else if (!this$storeName.equals(other$storeName)) {
                    return false;
                }

                Object this$tenantId = this.getTenantId();
                Object other$tenantId = other.getTenantId();
                if (this$tenantId == null) {
                    if (other$tenantId != null) {
                        return false;
                    }
                } else if (!this$tenantId.equals(other$tenantId)) {
                    return false;
                }

                return true;
            }
        }
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthUser;
    }


    public String toString() {
        return "AuthUser(username=" + this.getUsername() + ", nickName=" + this.getNickName() + ", face=" + this.getFace() + ", id=" + this.getId() + ", longTerm=" + this.getLongTerm() + ", role=" + this.getRole() + ", storeId=" + this.getStoreId() + ", clerkId=" + this.getClerkId() + ", storeName=" + this.getStoreName() + ", isSuper=" + this.getIsSuper() + ", tenantId=" + this.getTenantId() + ")";
    }

    public AuthUser() {
    }

    public AuthUser(String username, String nickName, String face, String id, Boolean longTerm, UserEnums role, String storeId, String clerkId, String storeName, Boolean isSuper, String tenantId) {
        this.username = username;
        this.nickName = nickName;
        this.face = face;
        this.id = id;
        this.longTerm = longTerm;
        this.role = role;
        this.storeId = storeId;
        this.clerkId = clerkId;
        this.storeName = storeName;
        this.isSuper = isSuper;
        this.tenantId = tenantId;
    }

    public static class AuthUserBuilder {
        private String username;
        private String nickName;
        private String face;
        private String id;
        private Boolean longTerm;
        private UserEnums role;
        private String storeId;
        private String clerkId;
        private String storeName;
        private Boolean isSuper;
        private String tenantId;

        AuthUserBuilder() {
        }

        public AuthUser.AuthUserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public AuthUser.AuthUserBuilder nickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public AuthUser.AuthUserBuilder face(String face) {
            this.face = face;
            return this;
        }

        public AuthUser.AuthUserBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AuthUser.AuthUserBuilder longTerm(Boolean longTerm) {
            this.longTerm = longTerm;
            return this;
        }

        public AuthUser.AuthUserBuilder role(UserEnums role) {
            this.role = role;
            return this;
        }

        public AuthUser.AuthUserBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public AuthUser.AuthUserBuilder clerkId(String clerkId) {
            this.clerkId = clerkId;
            return this;
        }

        public AuthUser.AuthUserBuilder storeName(String storeName) {
            this.storeName = storeName;
            return this;
        }

        public AuthUser.AuthUserBuilder isSuper(Boolean isSuper) {
            this.isSuper = isSuper;
            return this;
        }

        public AuthUser.AuthUserBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public AuthUser build() {
            return new AuthUser(this.username, this.nickName, this.face, this.id, this.longTerm, this.role, this.storeId, this.clerkId, this.storeName, this.isSuper, this.tenantId);
        }

        public String toString() {
            return "AuthUser.AuthUserBuilder(username=" + this.username + ", nickName=" + this.nickName + ", face=" + this.face + ", id=" + this.id + ", longTerm=" + this.longTerm + ", role=" + this.role + ", storeId=" + this.storeId + ", clerkId=" + this.clerkId + ", storeName=" + this.storeName + ", isSuper=" + this.isSuper + ", tenantId=" + this.tenantId + ")";
        }
    }
}

