package cn.com.duiba.tuia.robot.center.api.domain.vo;

import cn.com.duiba.tuia.robot.center.api.domain.dos.AdminUser;
import cn.com.duiba.tuia.robot.center.api.domain.dos.Menu;
import cn.com.duiba.tuia.robot.center.api.domain.dos.Role;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.BeanUtils;

import java.util.List;

@Data
public class AdminUserVO extends AdminUser {

    private static final long serialVersionUID = -2378384199695839312L;

    @ApiModelProperty(value = "所属部门名称")
    private String departmentTitle;

    @ApiModelProperty(value = "用户拥有角色")
    private List<Role> roles;

    @ApiModelProperty(value = "用户拥有的权限")
    private List<Menu> menus;


    public AdminUserVO(AdminUser user) {
        BeanUtils.copyProperties(user, this);
    }
}
