package cn.com.duiba.tuia.robot.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.robot.center.api.domain.dos.Department;
import cn.com.duiba.tuia.robot.center.api.domain.dos.DepartmentRole;

import java.util.List;
@AdvancedFeignClient
public interface RemoteDepartmentRoleService {

    /**
     * 根据部门获取角色集合
     *
     * @param departmentId
     * @return
     */
    List<DepartmentRole> listByDepartmentId(String departmentId);


    /**
     * 更新部门角色关联
     *
     * @param departmentId
     * @param departmentRoles
     */
    void updateByDepartmentId(String departmentId, List<DepartmentRole> departmentRoles);

    /**
     * 根据部门id删除部门与角色关联
     *
     * @param ids id集合
     */
    void deleteByDepartment(List<String> ids);


    DepartmentRole getById(String id);
}
