package cn.com.duiba.tuia.robot.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.robot.center.api.domain.dos.Menu;
import cn.com.duiba.tuia.robot.center.api.domain.dto.AuthUser;
import cn.com.duiba.tuia.robot.center.api.domain.req.MenuSearchParams;
import cn.com.duiba.tuia.robot.center.api.domain.vo.MenuVO;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMenuService {
    /**
     * 通过用户的菜单权限
     *
     * @return
     */
    List<MenuVO> findUserTree(AuthUser authUser);

    /**
     * 通过用户id获取
     *
     * @param userId
     * @return
     */
    List<Menu> findUserList(String userId);


    /**
     * 根据角色id获取菜单集合
     *
     * @param roleIds
     * @return
     */
    List<Menu> findByRoleIds(String roleIds);

    /**
     * 树形结构
     *
     * @return
     */
    List<MenuVO> tree();

    /**
     * 查询列表
     *
     * @param menuSearchParams
     * @return
     */
    List<Menu> searchList(MenuSearchParams menuSearchParams);

    /**
     * 批量删除
     *
     * @param ids
     */
    void deleteIds(List<String> ids);

    /**
     * 添加更新菜单
     *
     * @param menu 菜单数据
     * @return 是否成功
     */
    boolean saveOrUpdateMenu(Menu menu);
}
