package cn.com.duiba.tuia.robot.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.robot.center.api.domain.dos.VerificationSource;
import cn.com.duiba.tuia.robot.center.api.domain.dto.VerificationDTO;
import cn.com.duiba.tuia.robot.center.api.domain.vo.PageVO;
import cn.com.duiba.tuia.robot.center.api.domain.vo.SearchVO;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

@AdvancedFeignClient
public interface RemoteVerificationSourceService {

    /**
     * 初始化缓存
     *
     * @return
     */
    VerificationDTO initCache();

    /**
     * 获取验证缓存
     *
     * @return 验证码
     */
    VerificationDTO getVerificationCache();


    VerificationSource getById(String id);

    Page<VerificationSource> page(PageVO page,
                                  VerificationSource entity,
                                  SearchVO searchVo);


    void save(VerificationSource verificationSource);

    void updateById(VerificationSource verificationSource);

    void removeByIds(List ids);
}
