/**
 * Project Name:media-api File Name:AccountDayReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年11月30日下午3:06:46 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:AccountDayReport <br/>
 * Function: 媒体用户日报表. <br/>
 * Date: 2016年11月30日 下午3:06:46 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class AccountDayReportDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3266371532640694635L;

    /** id */
    private Long              id;

    /** 媒体用户id */
    private Long              mediaId;

    /** 媒体id */
    private Long              appId;

    /** 广告id */
    private Long              slotId;

    /** 每日曝光数 */
    private Integer           exposureCount;

    /** 每日点击数 */
    private Integer           clickCount;

    /** 每日发券量 */
    private Integer           launchCount;

    /** 广告点击量 */
    private Integer           efClickCount;

    /** 每日点击uv */
    private Integer           clickCountUv;

    /** 每日消费(分) */
    private Long              consumeTotal;

    /** 每日预计分成(分) */
    private Long              exConsumeTotal;

    /** 每日广告消耗(分) */
    private Long              adConsume;

    /** 当天日期 */
    private Date              curDate;

    /**
     * id.
     *
     * @return the id
     * @since JDK 1.6
     */
    public Long getId() {
        return id;
    }

    /**
     * id.
     *
     * @param id the id to set
     * @since JDK 1.6
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * exposureCount.
     *
     * @return the exposureCount
     * @since JDK 1.6
     */
    public Integer getExposureCount() {
        return exposureCount;
    }

    /**
     * exposureCount.
     *
     * @param exposureCount the exposureCount to set
     * @since JDK 1.6
     */
    public void setExposureCount(Integer exposureCount) {
        this.exposureCount = exposureCount;
    }

    /**
     * clickCount.
     *
     * @return the clickCount
     * @since JDK 1.6
     */
    public Integer getClickCount() {
        return clickCount;
    }

    /**
     * clickCount.
     *
     * @param clickCount the clickCount to set
     * @since JDK 1.6
     */
    public void setClickCount(Integer clickCount) {
        this.clickCount = clickCount;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Integer getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Integer launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * efClickCount.
     *
     * @return the efClickCount
     * @since JDK 1.6
     */
    public Integer getEfClickCount() {
        return efClickCount;
    }

    /**
     * efClickCount.
     *
     * @param efClickCount the efClickCount to set
     * @since JDK 1.6
     */
    public void setEfClickCount(Integer efClickCount) {
        this.efClickCount = efClickCount;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * clickCountUv.
     *
     * @return the clickCountUv
     * @since JDK 1.6
     */
    public Integer getClickCountUv() {
        return clickCountUv;
    }

    /**
     * clickCountUv.
     *
     * @param clickCountUv the clickCountUv to set
     * @since JDK 1.6
     */
    public void setClickCountUv(Integer clickCountUv) {
        this.clickCountUv = clickCountUv;
    }

    /**
     * exConsumeTotal.
     *
     * @return the exConsumeTotal
     * @since JDK 1.6
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * exConsumeTotal.
     *
     * @param exConsumeTotal the exConsumeTotal to set
     * @since JDK 1.6
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * adConsume.
     *
     * @return the adConsume
     * @since JDK 1.6
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * adConsume.
     *
     * @param adConsume the adConsume to set
     * @since JDK 1.6
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume; 
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
