/**
 * Project Name:media-biz<br>
 * File Name:AccountBankDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.domain<br>
 * Date:2016年9月27日下午2:05:17<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AccountBankDto <br/>
 * date: 2016年9月27日 下午2:05:18 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
public class AccountBankDto extends BaseDto {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = -4868643798716913156L;

    /**审核状态-未认证*/
    public  static final int CHECK_STATUS_UNAUTHORIZED=0;

    /**审核状态-认证中*/
    public  static final int CHECK_STATUS_AUTHORIZE_IN=1;

    /**审核状态-认证通过*/
    public  static final int CHECK_STATUS_AUTHORIZE_PASS=2;

    /**审核状态-认证拒绝*/
    public  static final int CHECK_STATUS_AUTHORIZE_REFUSE=3;

    /** 媒体用户ID. */
    private Long              mediaId;

    /** 银行卡号. */
    private String            cardNumber;

    /** 开户银行名称. */
    private String            bankName;

    /** 开户银行所在省编码. */
    private String            province;

    /** 开户银行所在市编码. */
    private String            city;

    /** 支行名称. */
    private String            branchName;
    
    /** 媒体账户审核信息(拒绝原因). */
    private String            checkMsg;

    /** 媒体账户审核状态(0：待审核；1：审核通过；2：审核拒绝) */
    private Integer           checkStatus;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * cardNumber.
     *
     * @return the cardNumber
     * @since JDK 1.6
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /**
     * cardNumber.
     *
     * @param cardNumber the cardNumber to set
     * @since JDK 1.6
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /**
     * bankName.
     *
     * @return the bankName
     * @since JDK 1.6
     */
    public String getBankName() {
        return bankName;
    }

    /**
     * bankName.
     *
     * @param bankName the bankName to set
     * @since JDK 1.6
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    /**
     * province.
     *
     * @return the province
     * @since JDK 1.6
     */
    public String getProvince() {
        return province;
    }

    /**
     * province.
     *
     * @param province the province to set
     * @since JDK 1.6
     */
    public void setProvince(String province) {
        this.province = province;
    }

    /**
     * city.
     *
     * @return the city
     * @since JDK 1.6
     */
    public String getCity() {
        return city;
    }

    /**
     * city.
     *
     * @param city the city to set
     * @since JDK 1.6
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * branchName.
     *
     * @return the branchName
     * @since JDK 1.6
     */
    public String getBranchName() {
        return branchName;
    }

    /**
     * branchName.
     *
     * @param branchName the branchName to set
     * @since JDK 1.6
     */
    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getCheckMsg() {
		return checkMsg;
	}

	public void setCheckMsg(String checkMsg) {
		this.checkMsg = checkMsg;
	}

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
