/**
 * Project Name:media-api File Name:MeidaActivitySlotStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto
 * Date:2016年12月19日下午1:54:35 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:MeidaActivitySlotStatisticsDto <br/>
 * Function: 媒体活动广告统计. <br/>
 * Date: 2016年12月19日 下午1:54:35 <br/>
 *
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class MeidaActivitySlotStatisticsHourDto extends BaseDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 7964975683391052338L;

    /** 媒体用户ID */
    private Long              mediaId;
    /** 媒体ID */
    private Long              appId;
    /** 媒体名称 */
    private String            appName;
    /** 所属平台 */
    private String            platform;
    /** 活动ID */
    private Long              activityId;
    /** 活动类型 */
    private String            activityType;
    /** 活动名 */
    private String            activityTitle;
    /** 广告位ID */
    private Long              slotId;
    /** 广告位名称 */
    private String            slotName;
    /** 广告位类型 */
    private Integer           slotType;
    /** 入口曝光量 */
    private Long              actExposeCount;
    /** 入口点击量 */
    private Long              actClickCount;
    /** 曝光点击率 */
    private Long              actClickRate;
    /** 入口点击UV */
    private Long              actClickUv;
    /** 活动参与次数 */
    private Long              participateCount;
    /** 活动参与人数 */
    private Long              participateUv;
    /** 参与率 */
    private Long              actParticipateRate;
    /** 复参数 */
    private Long              rptParticipateCount;
    /** 活动点击单价（分） */
    private Long              actPerClickFee;
    /** 每日发券量 */
    private Long              launchCount;
    /** 发券成功率 */
    private Long              launchSuccessRate;
    /** 广告曝光量 */
    private Long              advertExposureCount;
    /** 广告点击量 */
    private Long              advertClickCount;
    /** 广告点击率 */
    private Long              advertClickRate;
    /** 广告点击单价（分） */
    private Long              advertPerClickFee;
    /** 广告收入/广告点击量 */
    private Long              arpu;
    /** 千次曝光产生的发券 */
    private Long              spm;
    /** 千次曝光产生的广告消耗（分） */
    private Long              ecpm;
    /** 广告消耗（分） */
    private Long              adConsume;
    /** 媒体预计分成（分） */
    private Long              exConsumeTotal;
    /** 媒体应得分成（分） */
    private Long              consumeTotal;
    /** 当天日期 */
    private Date              curDate;
    /** 入口访问量 */
    private Long              actShowCount;
    /** 统计时段 */
    private String            curHour;
    /** 广告位规格ID */
    private Long              slotMsId;
    /** 活动请求PV */
    private Long              actRequestCount;
    /** 活动请求UV */
    private Long              actRequestUv;
    /** 活动广告券请求 */
    private Long              advertRequestCount;
    /** 请求成功率 */
    private Long              requestSuccessRate;
    /**广告位成功返回pv*/
    private Long              actSucResponseCount;
    /**广告位点击pv*/
    private Long             efClickCount;
    /** 广告位访问PV */
    private Long              sdkPv;
    /** 广告位访问UV */
    private Long              sdkUv;

    /**
     * slotMsId.
     *
     * @return the slotMsId
     * @since JDK 1.6
     */
    public Long getSlotMsId() {
        return slotMsId;
    }

    /**
     * slotMsId.
     *
     * @param slotMsId the slotMsId to set
     * @since JDK 1.6
     */
    public void setSlotMsId(Long slotMsId) {
        this.slotMsId = slotMsId;
    }

    /**
     * actRequestCount.
     *
     * @return the actRequestCount
     * @since JDK 1.6
     */
    public Long getActRequestCount() {
        return actRequestCount;
    }

    /**
     * actRequestCount.
     *
     * @param actRequestCount the actRequestCount to set
     * @since JDK 1.6
     */
    public void setActRequestCount(Long actRequestCount) {
        this.actRequestCount = actRequestCount;
    }

    /**
     * actRequestUv.
     *
     * @return the actRequestUv
     * @since JDK 1.6
     */
    public Long getActRequestUv() {
        return actRequestUv;
    }

    /**
     * actRequestUv.
     *
     * @param actRequestUv the actRequestUv to set
     * @since JDK 1.6
     */
    public void setActRequestUv(Long actRequestUv) {
        this.actRequestUv = actRequestUv;
    }

    /**
     * advertRequestCount.
     *
     * @return the advertRequestCount
     * @since JDK 1.6
     */
    public Long getAdvertRequestCount() {
        return advertRequestCount;
    }

    /**
     * advertRequestCount.
     *
     * @param advertRequestCount the advertRequestCount to set
     * @since JDK 1.6
     */
    public void setAdvertRequestCount(Long advertRequestCount) {
        this.advertRequestCount = advertRequestCount;
    }

    /**
     * requestSuccessRate.
     *
     * @return the requestSuccessRate
     * @since JDK 1.6
     */
    public Long getRequestSuccessRate() {
        return requestSuccessRate;
    }

    /**
     * requestSuccessRate.
     *
     * @param requestSuccessRate the requestSuccessRate to set
     * @since JDK 1.6
     */
    public void setRequestSuccessRate(Long requestSuccessRate) {
        this.requestSuccessRate = requestSuccessRate;
    }

    /**
     * curHour.
     *
     * @return the curHour
     * @since JDK 1.6
     */
    public String getCurHour() {
        return curHour;
    }

    /**
     * curHour.
     *
     * @param curHour the curHour to set
     * @since JDK 1.6
     */
    public void setCurHour(String curHour) {
        this.curHour = curHour;
    }

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * platform.
     *
     * @return the platform
     * @since JDK 1.6
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * platform.
     *
     * @param platform the platform to set
     * @since JDK 1.6
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * activityId.
     *
     * @return the activityId
     * @since JDK 1.6
     */
    public Long getActivityId() {
        return activityId;
    }

    /**
     * activityId.
     *
     * @param activityId the activityId to set
     * @since JDK 1.6
     */
    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    /**
     * activityType.
     *
     * @return the activityType
     * @since JDK 1.6
     */
    public String getActivityType() {
        return activityType;
    }

    /**
     * activityType.
     *
     * @param activityType the activityType to set
     * @since JDK 1.6
     */
    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    /**
     * activityTitle.
     *
     * @return the activityTitle
     * @since JDK 1.6
     */
    public String getActivityTitle() {
        return activityTitle;
    }

    /**
     * activityTitle.
     *
     * @param activityTitle the activityTitle to set
     * @since JDK 1.6
     */
    public void setActivityTitle(String activityTitle) {
        this.activityTitle = activityTitle;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * actExposeCount.
     *
     * @return the actExposeCount
     * @since JDK 1.6
     */
    public Long getActExposeCount() {
        return actExposeCount;
    }

    /**
     * actExposeCount.
     *
     * @param actExposeCount the actExposeCount to set
     * @since JDK 1.6
     */
    public void setActExposeCount(Long actExposeCount) {
        this.actExposeCount = actExposeCount;
    }

    /**
     * actClickCount.
     *
     * @return the actClickCount
     * @since JDK 1.6
     */
    public Long getActClickCount() {
        return actClickCount;
    }

    /**
     * actClickCount.
     *
     * @param actClickCount the actClickCount to set
     * @since JDK 1.6
     */
    public void setActClickCount(Long actClickCount) {
        this.actClickCount = actClickCount;
    }

    /**
     * actClickRate.
     *
     * @return the actClickRate
     * @since JDK 1.6
     */
    public Long getActClickRate() {
        return actClickRate;
    }

    /**
     * actClickRate.
     *
     * @param actClickRate the actClickRate to set
     * @since JDK 1.6
     */
    public void setActClickRate(Long actClickRate) {
        this.actClickRate = actClickRate;
    }

    /**
     * actClickUv.
     *
     * @return the actClickUv
     * @since JDK 1.6
     */
    public Long getActClickUv() {
        return actClickUv;
    }

    /**
     * actClickUv.
     *
     * @param actClickUv the actClickUv to set
     * @since JDK 1.6
     */
    public void setActClickUv(Long actClickUv) {
        this.actClickUv = actClickUv;
    }

    /**
     * participateCount.
     *
     * @return the participateCount
     * @since JDK 1.6
     */
    public Long getParticipateCount() {
        return participateCount;
    }

    /**
     * participateCount.
     *
     * @param participateCount the participateCount to set
     * @since JDK 1.6
     */
    public void setParticipateCount(Long participateCount) {
        this.participateCount = participateCount;
    }

    /**
     * participateUv.
     *
     * @return the participateUv
     * @since JDK 1.6
     */
    public Long getParticipateUv() {
        return participateUv;
    }

    /**
     * participateUv.
     *
     * @param participateUv the participateUv to set
     * @since JDK 1.6
     */
    public void setParticipateUv(Long participateUv) {
        this.participateUv = participateUv;
    }

    /**
     * actParticipateRate.
     *
     * @return the actParticipateRate
     * @since JDK 1.6
     */
    public Long getActParticipateRate() {
        return actParticipateRate;
    }

    /**
     * actParticipateRate.
     *
     * @param actParticipateRate the actParticipateRate to set
     * @since JDK 1.6
     */
    public void setActParticipateRate(Long actParticipateRate) {
        this.actParticipateRate = actParticipateRate;
    }

    /**
     * rptParticipateCount.
     *
     * @return the rptParticipateCount
     * @since JDK 1.6
     */
    public Long getRptParticipateCount() {
        return rptParticipateCount;
    }

    /**
     * rptParticipateCount.
     *
     * @param rptParticipateCount the rptParticipateCount to set
     * @since JDK 1.6
     */
    public void setRptParticipateCount(Long rptParticipateCount) {
        this.rptParticipateCount = rptParticipateCount;
    }

    /**
     * actPerClickFee.
     *
     * @return the actPerClickFee
     * @since JDK 1.6
     */
    public Long getActPerClickFee() {
        return actPerClickFee;
    }

    /**
     * actPerClickFee.
     *
     * @param actPerClickFee the actPerClickFee to set
     * @since JDK 1.6
     */
    public void setActPerClickFee(Long actPerClickFee) {
        this.actPerClickFee = actPerClickFee;
    }

    /**
     * launchCount.
     *
     * @return the launchCount
     * @since JDK 1.6
     */
    public Long getLaunchCount() {
        return launchCount;
    }

    /**
     * launchCount.
     *
     * @param launchCount the launchCount to set
     * @since JDK 1.6
     */
    public void setLaunchCount(Long launchCount) {
        this.launchCount = launchCount;
    }

    /**
     * launchSuccessRate.
     *
     * @return the launchSuccessRate
     * @since JDK 1.6
     */
    public Long getLaunchSuccessRate() {
        return launchSuccessRate;
    }

    /**
     * launchSuccessRate.
     *
     * @param launchSuccessRate the launchSuccessRate to set
     * @since JDK 1.6
     */
    public void setLaunchSuccessRate(Long launchSuccessRate) {
        this.launchSuccessRate = launchSuccessRate;
    }

    /**
     * advertExposureCount.
     *
     * @return the advertExposureCount
     * @since JDK 1.6
     */
    public Long getAdvertExposureCount() {
        return advertExposureCount;
    }

    /**
     * advertExposureCount.
     *
     * @param advertExposureCount the advertExposureCount to set
     * @since JDK 1.6
     */
    public void setAdvertExposureCount(Long advertExposureCount) {
        this.advertExposureCount = advertExposureCount;
    }

    /**
     * advertClickCount.
     *
     * @return the advertClickCount
     * @since JDK 1.6
     */
    public Long getAdvertClickCount() {
        return advertClickCount;
    }

    /**
     * advertClickCount.
     *
     * @param advertClickCount the advertClickCount to set
     * @since JDK 1.6
     */
    public void setAdvertClickCount(Long advertClickCount) {
        this.advertClickCount = advertClickCount;
    }

    /**
     * advertClickRate.
     *
     * @return the advertClickRate
     * @since JDK 1.6
     */
    public Long getAdvertClickRate() {
        return advertClickRate;
    }

    /**
     * advertClickRate.
     *
     * @param advertClickRate the advertClickRate to set
     * @since JDK 1.6
     */
    public void setAdvertClickRate(Long advertClickRate) {
        this.advertClickRate = advertClickRate;
    }

    /**
     * advertPerClickFee.
     *
     * @return the advertPerClickFee
     * @since JDK 1.6
     */
    public Long getAdvertPerClickFee() {
        return advertPerClickFee;
    }

    /**
     * advertPerClickFee.
     *
     * @param advertPerClickFee the advertPerClickFee to set
     * @since JDK 1.6
     */
    public void setAdvertPerClickFee(Long advertPerClickFee) {
        this.advertPerClickFee = advertPerClickFee;
    }

    /**
     * arpu.
     *
     * @return the arpu
     * @since JDK 1.6
     */
    public Long getArpu() {
        return arpu;
    }

    /**
     * arpu.
     *
     * @param arpu the arpu to set
     * @since JDK 1.6
     */
    public void setArpu(Long arpu) {
        this.arpu = arpu;
    }

    /**
     * spm.
     *
     * @return the spm
     * @since JDK 1.6
     */
    public Long getSpm() {
        return spm;
    }

    /**
     * spm.
     *
     * @param spm the spm to set
     * @since JDK 1.6
     */
    public void setSpm(Long spm) {
        this.spm = spm;
    }

    /**
     * ecpm.
     *
     * @return the ecpm
     * @since JDK 1.6
     */
    public Long getEcpm() {
        return ecpm;
    }

    /**
     * ecpm.
     *
     * @param ecpm the ecpm to set
     * @since JDK 1.6
     */
    public void setEcpm(Long ecpm) {
        this.ecpm = ecpm;
    }

    /**
     * adConsume.
     *
     * @return the adConsume
     * @since JDK 1.6
     */
    public Long getAdConsume() {
        return adConsume;
    }

    /**
     * adConsume.
     *
     * @param adConsume the adConsume to set
     * @since JDK 1.6
     */
    public void setAdConsume(Long adConsume) {
        this.adConsume = adConsume;
    }

    /**
     * exConsumeTotal.
     *
     * @return the exConsumeTotal
     * @since JDK 1.6
     */
    public Long getExConsumeTotal() {
        return exConsumeTotal;
    }

    /**
     * exConsumeTotal.
     *
     * @param exConsumeTotal the exConsumeTotal to set
     * @since JDK 1.6
     */
    public void setExConsumeTotal(Long exConsumeTotal) {
        this.exConsumeTotal = exConsumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @return the consumeTotal
     * @since JDK 1.6
     */
    public Long getConsumeTotal() {
        return consumeTotal;
    }

    /**
     * consumeTotal.
     *
     * @param consumeTotal the consumeTotal to set
     * @since JDK 1.6
     */
    public void setConsumeTotal(Long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * actShowCount.
     *
     * @return the actShowCount
     * @since JDK 1.6
     */
    public Long getActShowCount() {
        return actShowCount;
    }

    /**
     * actShowCount.
     *
     * @param actShowCount the actShowCount to set
     * @since JDK 1.6
     */
    public void setActShowCount(Long actShowCount) {
        this.actShowCount = actShowCount;
    }

    /**
     * actSucResponseCount.
     *
     * @return the actSucResponseCount
     * @since JDK 1.6
     */
    public Long getActSucResponseCount() {
        return actSucResponseCount;
    }

    public Long getEfClickCount() {
        return efClickCount;
    }

    public void setEfClickCount(Long efClickCount) {
        this.efClickCount = efClickCount;
    }

    public Long getSdkPv() {
        return sdkPv;
    }

    public void setSdkPv(Long sdkPv) {
        this.sdkPv = sdkPv;
    }

    public Long getSdkUv() {
        return sdkUv;
    }

    public void setSdkUv(Long sdkUv) {
        this.sdkUv = sdkUv;
    }

    /**
     * actSucResponseCount.
     *
     * @param actSucResponseCount the actSucResponseCount to set
     * @since JDK 1.6
     */
    public void setActSucResponseCount(Long actSucResponseCount) {
        this.actSucResponseCount = actSucResponseCount;
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
