/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppSlotHourStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月22日下午3:41:14<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ReqAppSlotHourStatistics <br/>
 * date: 2016年12月22日 下午3:41:14 <br/>
 * .
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAppSlotDailyStatistics extends ReqDateQuery {

    /**序列号*/
    private static final long serialVersionUID = -5541118616653683007L;

    /** The app id. */
    @ApiModelProperty(value = "媒体ID", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long   appId;

    /** The slot id. */
    @ApiModelProperty(value = "广告位ID", required = true)
    @NotNull(message = "广告位ID不能为空")
    private Long   slotId;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String appName;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称(用作导出)", required = false)
    private String slotName;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the slot id.
     *
     * @return the slot id
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * Sets the slot id.
     *
     * @param slotId the slot id
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
