/**
 * Project Name:ssp-center-api
 * File Name:RemoteManualSlotDailyStatService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月8日上午10:09:44
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;

import cn.com.duiba.tuia.ssp.center.api.dto.ManualSlotDailyStatDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteManualSlotDailyStatService <br/>
 * Function: 手动投放广告位日数据. <br/>
 * Date:     2017年6月8日 上午10:09:44 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteManualSlotDailyStatService {
    
    /**
     * 
     * saveManualSlotStatData:(保存手动投放广告位数据). <br/>
     *
     * @author guyan
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> saveManualSlotStatData(ManualSlotDailyStatDto dto);
    
    /**
     * 
     * selectManualSlotStatData:(查询手动投放广告位统计数据). <br/>
     *
     * @author guyan
     * @param appId
     * @param slotId
     * @param curDate
     * @return
     * @since JDK 1.6
     */
    DubboResult<ManualSlotDailyStatDto> selectManualSlotStatData(Long appId,Long slotId,Date curDate);
    
    /**
     * 
     * updateManualSlotStatDat:(修改手动投放统计的数据). <br/>
     *
     * @author guyan
     * @param dto
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateManualSlotStatDat(ManualSlotDailyStatDto dto);
    
}

