/**
 * Project Name:media-api File Name:ReqAccountDayReport.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年11月30日下午5:08:53 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:ReqAccountDayReport <br/>
 * Function: 日报表. <br/>
 * Date: 2016年11月30日 下午5:08:53 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqAccountDayReport implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -7607047345088496835L;

    /** 当前日期 */
    @ApiModelProperty(value = "当前日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "当前日期不能为空")
    private String            currentDate;

    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id")
    private Long              appId;
    
    @ApiModelProperty(value = "用户Id", required = true)
    private Long              mediaId;

    
    public Long getMediaId() {
        return mediaId;
    }

    
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getCurrentDate() {
        return currentDate;
    }

    public void setCurrentDate(String currentDate) {
        this.currentDate = currentDate;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
