/**
 * Project Name:ssp-center-api
 * File Name:ReqFinanceDetailByPage.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年5月4日下午2:23:19
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName:ReqFinanceDetailByPage <br/>
 * Function: 提现明细请求参数. <br/>
 * Date:     2017年5月4日 下午2:23:19 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see      
 */
@ApiModel
public class ReqCashDetail extends BaseQueryDto  {

    /**序列化号*/
    private static final long serialVersionUID = 1949978906028805595L;
    
    /**按创建时间排序*/
    public static final String SORD_DATE="gmt_create";
    
    /**降序排序*/
    public static final String ORDER_FIELD="desc";
    
    
    /** 审核状态 */
    @ApiModelProperty(value = "审核状态", required = true)
    private Integer           checkStatus;

    /** 查询开始日期. */
    @ApiModelProperty(value = "查询开始日期", required = true)
    private String            startDate;

    /** 查询结束日期. */
    @ApiModelProperty(value = "查询结束日期", required = true)
    private String            endDate;
    
    /**用户ID*/
    @ApiModelProperty(value = "用户ID", required = false)
    private Long              mediaId;

    /**提现单号ID*/
    @ApiModelProperty(value = "提现单号ID", required = false)
    private Long              cashOrderId;

    @ApiModelProperty(value = "媒体账号", required = false)
    private String mediaEmail;

    public String getMediaEmail() {
        return mediaEmail;
    }

    public void setMediaEmail(String mediaEmail) {
        this.mediaEmail = mediaEmail;
    }

    /**
     * Gets the checkStatus.
     *
     * @return the checkStatus
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * Sets the checkStatus.
     *
     * @param checkStatus the checkStatus
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * Gets the startDate.
     *
     * @return the startDate
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * Sets the startDate.
     *
     * @param startDate the startDate
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Gets the endDate.
     *
     * @return the endDate
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * Sets the endDate.
     *
     * @param endDate the endDate
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    
    /**
     * Gets the mediaId.
     *
     * @return the mediaId
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * Sets the mediaId.
     *
     * @param mediaId the mediaId
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * Gets the cashOrderId.
     *
     * @return the cashOrderId
     */
    public Long getCashOrderId() {
        return cashOrderId;
    }

    /**
     * Sets the cashOrderId.
     *
     * @param cashOrderId the cashOrderId
     */
    public void setCashOrderId(Long cashOrderId) {
        this.cashOrderId = cashOrderId;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

