/**
 * Project Name:media-biz File Name:UpdateMediaReq.java Package Name:cn.com.duiba.tuia.media.model
 * Date:2016年9月26日下午3:33:12 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.validator.constraints.Length;

/**
 * ClassName:ReqUpdateMediaApp <br/>
 * Date: 2016年9月26日 下午3:33:12 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateMediaApp implements Serializable {

    /** 序列号 */
    private static final long  serialVersionUID     = 5793038848276258068L;

    /** 开通状态:0-待审核. */
    public static final int    MEDIA_APP_CHECKING   = 0;
    /** 开通状态:1-审核通过. */
    public static final int    MEDIA_APP_CHECK_PASS = 1;
    /** 开通状态:2-审核拒绝. */
    public static final int    MEDIA_APP_CHECK_FAIL = 2;

    /** 平台类型 1 Android */
    public static final String PLATFORM_TYE_ANDROID = "1";
    /** 平台类型 2 IOS */
    public static final String PLATFORM_TYE_IOS     = "2";

    /** 平台类型-Android */
    public static final String PLATFORM_ANDROID     = "Android";
    /** 平台类型-IOS */
    public static final String PLATFORM_IOS         = "IOS";

    /** 媒体id. */
    @ApiModelProperty(value = "媒体id", required = true)
    @NotNull(message = "媒体id不能为空")
    private Long               appId;

    /** 媒体名称. */
    @ApiModelProperty(value = "媒体名称", required = true)
    @Length(min = 2, max = 10, message = "媒体名称最大不能超过10个字符")
    @NotNull(message = "媒体名称不能为空")
    private String             appName;

    /** 行业. */
    @ApiModelProperty(value = "行业类型", required = true)
    private String             industry;

    /** 系统平台. */
    @ApiModelProperty(value = "系统平台", required = true)
    @NotNull(message = "系统平台不能为空")
    private String             platform;

    /** 开通状态:0-待审核;1-审核通过;2-审核拒绝. */
    @ApiModelProperty(value = "审核状态", required = true)
    private Integer            checkStatus;

    /** 程序主包名. */
    @ApiModelProperty(value = "程序主包名", required = false)
    private String             appPackage;

    /** 媒体关键词. */
    @ApiModelProperty(value = "媒体关键词", required = false)
    @Length(max = 20, message = "媒体关键词最大不能超过20个字符")
    private String             appKeyWords;

    /** 媒体简介. */
    @ApiModelProperty(value = "媒体简介", required = false)
    @Length(max = 100, message = "最大不能超过100个字符!")
    private String             description;

    /** 下载地址. */
    @ApiModelProperty(value = "下载地址", required = false)
    private String             downloadUrl;

    /** 媒体账号ID */
    @ApiModelProperty(value = "媒体账号ID", required = false)
    private Long               mediaId;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getIndustry() {
        return industry;
    }

    public void setIndustry(String industry) {
        this.industry = industry;
    }

    public String getPlatform() {
        return platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getAppPackage() {
        return appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    public String getAppKeyWords() {
        return appKeyWords;
    }

    public void setAppKeyWords(String appKeyWords) {
        this.appKeyWords = appKeyWords;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDownloadUrl() {
        return downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public Integer getCheckStatus() {
        return checkStatus;
    }

    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
