/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * 广告位计费方式配置表Dto <br/>
 * Date: 2017年3月6日 下午5:05:11 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
public class SlotConfigDto extends BaseDto {

    /**
     * @since JDK 1.6
     */
    private static final long   serialVersionUID         = -5241747280526882286L;

    /** 计费方式分成 */
    public static final Integer CHARGE_TYPE_DIVIDED_INTO = 0;
    /** 计费方式CPC */
    public static final Integer CHARGE_TYPE_CPC          = 1;
    /** 计费方式CPM */
    public static final Integer CHARGE_TYPE_CPM          = 2;
    /** 默认广告位分成比例 */
    public static final Integer DEFAULT_SLOT_RATIO       = 7000;
    /** 默认平台分成比例 */
    public static final Integer DEFAULT_PLATFORM_RATIO   = 3000;
    /** 默认单价 */
    public static final Integer DEFAULT_PRICE            = 0;

    /** 媒体ID. */
    private Long                appId;

    /** 广告位ID. */
    private Long                slotId;

    /** 计费方式:0-分成;1-CPC;2-CPM */
    private Integer             chargeType;

    /** 价格（分） */
    private Integer             price;

    /** 媒体分账比例：% . */
    private Integer             mediaSplitRatio;

    /** 平台分账比例：% . */
    private Integer             platformSplitRatio;

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * chargeType.
     *
     * @return the chargeType
     * @since JDK 1.6
     */
    public Integer getChargeType() {
        return chargeType;
    }

    /**
     * chargeType.
     *
     * @param chargeType the chargeType to set
     * @since JDK 1.6
     */
    public void setChargeType(Integer chargeType) {
        this.chargeType = chargeType;
    }

    /**
     * price.
     *
     * @return the price
     * @since JDK 1.6
     */
    public Integer getPrice() {
        return price;
    }

    /**
     * price.
     *
     * @param price the price to set
     * @since JDK 1.6
     */
    public void setPrice(Integer price) {
        this.price = price;
    }

    /**
     * mediaSplitRatio.
     *
     * @return the mediaSplitRatio
     * @since JDK 1.6
     */
    public Integer getMediaSplitRatio() {
        return mediaSplitRatio;
    }

    /**
     * mediaSplitRatio.
     *
     * @param mediaSplitRatio the mediaSplitRatio to set
     * @since JDK 1.6
     */
    public void setMediaSplitRatio(Integer mediaSplitRatio) {
        this.mediaSplitRatio = mediaSplitRatio;
    }

    /**
     * platformSplitRatio.
     *
     * @return the platformSplitRatio
     * @since JDK 1.6
     */
    public Integer getPlatformSplitRatio() {
        return platformSplitRatio;
    }

    /**
     * platformSplitRatio.
     *
     * @param platformSplitRatio the platformSplitRatio to set
     * @since JDK 1.6
     */
    public void setPlatformSplitRatio(Integer platformSplitRatio) {
        this.platformSplitRatio = platformSplitRatio;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
