package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.AccountDayReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountDayReport;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAppDayBillByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDayBillDetailByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotDayBillByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

public interface RemoteAccountReportDayService {
    DubboResult<List<AccountDayReportDto>> selectAppDayBillList(ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<AccountDayReportDto>> selectLineData(ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<AccountDayReportDto>> selectList(ReqAccountDayReport reqAccountDayReport);

    DubboResult<List<AccountDayReportDto>> selectAppDayBillByPage(ReqAppDayBillByPage reqAppDayBillByPage);

    DubboResult<List<AccountDayReportDto>> selectSlotDayBillByPage(ReqAccountDayReport reqAccountDayReport);

    DubboResult<Integer> selectAppDayBillAmount(ReqAppDayBillByPage reqAppDayBillByPage);

    DubboResult<Integer> selectSlotDayBillAmount(ReqSlotDayBillByPage reqSlotDayBillByPage);

    DubboResult<List<AccountDayReportDto>> selectDayBillDetail(ReqDayBillDetailByPage reqDayBillDetailByPage);

    DubboResult<Integer> selectDayBillDetailAmount(ReqDayBillDetailByPage reqDayBillDetailByPage);

    /**
     * 根据日期导出每日账单
     * @param slotId
     * @param currentDate
     * @return
     */
    DubboResult<List<AccountDayReportDto>> selectExportList(Long slotId, Date currentDate);

    DubboResult<List<AccountDayReportDto>> selectBillByMedia(Long mediaId,List<Date> dates);
}
