package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaCashOrderDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqCashDetail;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * 媒体提现单service
 * 
 *
 */
public interface RemoteMediaCashOrderService {

    /**
     * 增加一条媒体提现单记录
     * @param mediaCashOrderDto
     * @return
     */
    public DubboResult<Boolean> addOrder(MediaCashOrderDto mediaCashOrderDto);

    /**
     *  根据id更新提现单记录
     * @param mediaCashOrderDto
     * @return
     */
    public DubboResult<Boolean> updateOrderById(MediaCashOrderDto mediaCashOrderDto);

    /**
     *  根据cashOrderId更新提现单记录
     * @param mediaCashOrderDto
     * @return
     */
    public DubboResult<Boolean> updateOrderByCashOrderId(MediaCashOrderDto mediaCashOrderDto);


    /**
     *  根据id查询一条提现单记录
     * @param id
     * @return
     */
    public DubboResult<MediaCashOrderDto>    getOrderById(Long id);

    /**
     * 根据媒体id查询所有的提现单记录
     * @param id
     * @return
     */
    public DubboResult<List<MediaCashOrderDto>>    getOrdersByMediaId(Long id);
    
    /**
     * 
     * getOrdersList:(查询提现明细列表). <br/>
     * 
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<List<MediaCashOrderDto>>   getCashOrdersList(ReqCashDetail param);
    
    /**
     * 
     * getCashOrdersCount:(查询提现明细). <br/>
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Integer>  getCashOrdersCount(ReqCashDetail param);

    /**
     * 修改提现状态，需修改cash_order表和account_report_month表状态
     * @param cashOrderId
     * @param status
     * @return
     */
    public DubboResult<Boolean>  updateCashStatus(Long cashOrderId,Integer status,String checkMsg);
    
}
