package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.ssp.center.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;


public interface RemoteTuiaActivityService {

    /**
     * 获取活动定向的媒体
     *
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer source);

    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer source);

    /**
     * 查询某个活动在某个广告位下的SPM值
     *
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 活动SPM
     */
    DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType);

    /**
     * 将活动从试投列表中移除
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActList(Long activityId, Integer source);
    
    /**
     * 获取活动计划明细
     *
     * @param activityId 活动ID
     * @param source 活动来源
     * @return 活动计划
     */
    DubboResult<RspActivityDto> getActivityPlanDetail(Long activityId, Integer source, Map<Integer, String> actTypeMap);

}
