/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppHourStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月22日上午11:25:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ReqAppHourStatistics <br/>
 * Function: 每小时数据请求对象. <br/>
 * date: 2016年12月22日 上午11:25:45 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqAppHourStatistics extends ReqStatHourlySort{

    /** 媒体ID. */
    @ApiModelProperty(value = "媒体ID", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long   appId;

    /** 查询日期. */
    @ApiModelProperty(value = "查询日期", required = true)
    @NotNull(message = "查询日期不能为空")
    private String curDate;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String appName;

    /** The platform. */
    @ApiModelProperty(value = "媒体所属平台(用作导出)", required = false)
    private String platform;

    /**
     * Gets the app id.
     *
     * @return the app id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * Sets the app id.
     *
     * @param appId the app id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * Gets the cur date.
     *
     * @return the cur date
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * Sets the cur date.
     *
     * @param curDate the cur date
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * Gets the app name.
     *
     * @return the app name
     */
    public String getAppName() {
        return appName;
    }

    /**
     * Sets the app name.
     *
     * @param appName the app name
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * Gets the platform.
     *
     * @return the platform
     */
    public String getPlatform() {
        return platform;
    }

    /**
     * Sets the platform.
     *
     * @param platform the platform
     */
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
