/**
 * Project Name:media-api File Name:RspSettledMonthReportDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年11月30日下午3:52:36 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspSettledMonthReportDto <br/>
 * Function: 已结算月报表. <br/>
 * Date: 2016年11月30日 下午3:52:36 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class SettledMonthReportRsp extends BaseAccountMonthReportRsp implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 3670897234679755232L;

    /** 月发劵量 */
    private Integer           monthAdvertCount;

    /** 月曝光数 */
    private Integer           monthShowCount;

    /** 月点击量 */
    private Integer           monthClickCount;

    /** 日点击uv总数 */
    private Integer           allDayClickUvCount;

    /** 月有效点击量 */
    private Integer           monthValidClickCount;

    /** 最终分成 */
    private Long              finalShare;

    /** 结算状态：0-待结算，1-默认结算，2-拒绝结算 */
    private Integer           checkStatus;

    /** 审核状态：0-拒绝，1-通过 */
    private Integer           auditStatus;

    /**
     * settlementStatus.
     *
     * @return the settlementStatus
     * @since JDK 1.6
     */
    public Integer getCheckStatus() {
        return checkStatus;
    }

    /**
     * checkStatus.
     *
     * @param checkStatus the checkStatus to set
     * @since JDK 1.6
     */
    public void setCheckStatus(Integer checkStatus) {
        this.checkStatus = checkStatus;
    }

    /**
     * auditStatus.
     *
     * @return the auditStatus
     * @since JDK 1.6
     */
    public Integer getAuditStatus() {
        return auditStatus;
    }

    /**
     * auditStatus.
     *
     * @param auditStatus the auditStatus to set
     * @since JDK 1.6
     */
    public void setAuditStatus(Integer auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Integer getMonthAdvertCount() {
        return monthAdvertCount;
    }

    public void setMonthAdvertCount(Integer monthAdvertCount) {
        this.monthAdvertCount = monthAdvertCount;
    }

    public Integer getMonthShowCount() {
        return monthShowCount;
    }

    public void setMonthShowCount(Integer monthShowCount) {
        this.monthShowCount = monthShowCount;
    }

    public Integer getMonthClickCount() {
        return monthClickCount;
    }

    public void setMonthClickCount(Integer monthClickCount) {
        this.monthClickCount = monthClickCount;
    }

    public Integer getAllDayClickUvCount() {
        return allDayClickUvCount;
    }

    public void setAllDayClickUvCount(Integer allDayClickUvCount) {
        this.allDayClickUvCount = allDayClickUvCount;
    }

    public Integer getMonthValidClickCount() {
        return monthValidClickCount;
    }

    public void setMonthValidClickCount(Integer monthValidClickCount) {
        this.monthValidClickCount = monthValidClickCount;
    }

    public Long getFinalShare() {
        return finalShare;
    }

    public void setFinalShare(Long finalShare) {
        this.finalShare = finalShare;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);

    }

}
