package cn.com.duiba.tuia.ssp.center.api.remote;


import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.AccountMonthReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountMonthReportByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMonthBillDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SettledMonthReportRsp;
import cn.com.duiba.wolf.dubbo.DubboResult;

public interface RemoteAccountReportMonthService {

    DubboResult<Integer> selectAmountByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<List<SettledMonthReportRsp>> selectListByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<AccountMonthReportDto> selectMonthReportByReportId(Long reportId);

    DubboResult<List<SettledMonthReportRsp>> selectExportList(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<Boolean> updateMonthReportStatus(Long reportId,Integer settlementStatus);


    /**
     * 查询媒体所有可提现月账单
     * @param mediaId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByMediaId (Long mediaId);

    /**
     * 绑定月账单和提现单
     * @param reportId
     * @param cashOrderId
     * @return
     */
    DubboResult<Boolean> updateMonthReportCashOrder(Long reportId,Long cashOrderId);

    /**
     * 通过提现单查询月账单
     * @param cashOrderId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByCashOrderId ( Long cashOrderId);
    
    /**
     * 
     * 查询用户下所有的月账单数据
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectAllMonthBillList(ReqMonthBillDto param);
    
    /**
     * 
     * 查询用户下所有的月账单总数
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> selectAllMonthBillCount(ReqMonthBillDto param);
    
    /**
     * 
     * 查询上个月月账单ID <br/>
     *  
     * @param mediaId
     * @param appId
     * @param lastMonth
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> getLastMonthBillId(Long mediaId,Long appId,String lastMonth);
    
    /**
     * 批量修改月账单
     * 
     * @param monthBillIds
     * @param cashOrderId
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> batchUpdateMonthBill(List<Long> appIds,List<String> curDates,Long cashOrderId,Long mediaId);
   

    /**
     * 查询媒体下各个应用的每月的预计分成
     *
     * @param cashOrderId
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectBillByCashOrder(Long cashOrderId);
    
    /**
     * 查询已结算月账单
     *
     * @param monthBillId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountMonthReportDto> selectSettledMonthBill(Long monthBillId);

    /**
     * 通过提现单查询对应的月账单Id
     * @param cashOrderIds
     * @return
     */
    DubboResult<List<Long>> selectIdsByCashOrderIds(List<Long> cashOrderIds);
}
