/**
 * Project Name:ssp-center-api
 * File Name:RemoteAccountSettlementService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年5月22日下午5:22:20
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.AccountSettlementDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteAccountSettlementService <br/>
 * Function: 用户结算数据. <br/>
 * Date:     2017年5月22日 下午5:22:20 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteAccountSettlementService {
    
    /**
     * 通过月账单IDS 查询结算数据
     * 
     * @param billIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountSettlementDto>> getSettlementList(List<Long> appIds,List<String> curDates,Long mediaId);
    
    /**
     * 通过账单ID 查询结算数据信息
     *
     * @param billId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountSettlementDto> getSettlementById(Long billId);
    
    /**
     * 通过月账单IDS 查询提现金额
     *
     * @param billIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<Long> getSettlementAmountByIds(List<Long> appIds,List<String> curDates,Long mediaId);
    
    /**
     * 查询一条用户结算数据
     *
     * @param appId
     * @param curDate
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountSettlementDto> getAccountSettlement(Long appId,String curDate,Long mediaId);
}

