package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.ActivityCenterDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivityCenterDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityCenterDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

public interface RemoteActivityCenterService {
    /**
     * 置顶活动或取消置顶，任意参数为null返回0<br/>
     *
     * @param activityId  活动id
     * @param source     活动来源 0 兑吧 1 推啊 2 流量引导页
     * @param status     0 不置顶 1 置顶
     * @return
     */
    DubboResult<Integer> updateIsTopStatus(Long activityId, Integer source, Integer status);

    /**
     * 查询活动中心的活动，提供没媒体管理后台<br/>
     *
     * @param req
     * @return
     */
    DubboResult<List<ActivityCenterDto>> selectLists(ReqActivityCenterDto req);

    /**
     * 查询活动中心活动，提供给活动中心,查询所有开启未删除的活动<br/>
     * 如果屏蔽后数量少于10个则不屏蔽，否者执行屏蔽策略</br>
     * @param slotId 广告位Id 影响对应的屏蔽策略
     * @return
     */
    DubboResult<List<RspActivityCenterDto>> selectAllLists(Long slotId);

    /**
     * 移除一条活动，参数任意为null，返回0<br/>
     *
     * @param activityId  活动id
     * @param source      活动来源 0 兑吧 1 推啊 2 流量引导页
     * @return
     */
    DubboResult<Integer> delete(Long activityId, Integer source);

    /**
     * 批量插入活动，如果活动已存在则不进行插入也不进行更新<br/>
     *
     * @param activityIds  活动id集合
     * @param source       活动来源 0 兑吧 1 推啊 2 流量引导页
     * @return
     */
    DubboResult<Integer> insert(List<Long> activityIds, Integer source);
    
    /**
     * 
     * 修改活动标签
     *
     * @author guyan
     * @param activityId:活动标签
     * @param source:活动来源
     * @param tag:活动标签
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateActivityTag(Long activityId,Integer source,String tag);
}