/**
 * Project Name:media-manager-biz<br/>
 * File Name:SlotStatisticsDataReq.java<br/>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br/>
 * Date:2016年12月21日下午2:25:37<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * ClassName:SlotStatisticsDataReq <br/>
 * Function: 广告位数据统计 <br/>
 * Date: 2016年12月21日 下午2:25:37 <br/>
 * 
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqSlotStatDataByPage extends ReqPageQuery {

    /**序列号*/
    private static final long serialVersionUID = -8601483502031284507L;

    @ApiModelProperty(value = "广告位ID", required = false)
    private Long       slotId;

    @ApiModelProperty(value = "广告位名称", required = false)
    private String     slotName;

    @ApiModelProperty(value = "广告位类型", required = false)
    private Integer    slotType;

    @ApiModelProperty(value = "媒体ID", required = false)
    private Long       appId;

    @ApiModelProperty(value = "媒体名称", required = false)
    private String     appName;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "开始日期不能为空")
    private String     startDate;

    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "结束日期不能为空")
    private String     endDate;
    
    /**媒体IDS*/
    @ApiModelProperty(value = "媒体IDS", required = false)
    private List<Long> appIds;
   
    /**广告位IDS*/
    @ApiModelProperty(value = "广告位IDS", required = false)
    private List<Long> slotIds;
    
    /**多个排序字段*/
    @ApiModelProperty(value = "多个排序字段", required = false)
    private String sorts;

    /** 导出方式. */
    @ApiModelProperty(value = "导出方式", required = false)
    private Integer     exportType;//0是汇总，1是分日导出

    /** 用户ID. */
    @ApiModelProperty(value = "用户ID", required = false)
    private Long     mediaId;

    /** 用户邮箱. */
    @ApiModelProperty(value = "用户邮箱", required = false)
    private String     account;
    
    @ApiModelProperty(value = "标签id", required = false)
    private Long     tagId;

    public Integer getExportType() {
		return exportType;
	}

	public void setExportType(Integer exportType) {
		this.exportType = exportType;
	}
    
    /**
     * appIds.
     *
     * @return the appIds
     * @since JDK 1.6
     */
    public List<Long> getAppIds() {
        return appIds;
    }

    /**
     * appIds.
     *
     * @param appIds the appIds to set
     * @since JDK 1.6
     */
    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    /**
     * slotIds.
     *
     * @return the slotIds
     * @since JDK 1.6
     */
    public List<Long> getSlotIds() {
        return slotIds;
    }

    /**
     * slotIds.
     *
     * @param slotIds the slotIds to set
     * @since JDK 1.6
     */
    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * slotType.
     *
     * @return the slotType
     * @since JDK 1.6
     */
    public Integer getSlotType() {
        return slotType;
    }

    /**
     * slotType.
     *
     * @param slotType the slotType to set
     * @since JDK 1.6
     */
    public void setSlotType(Integer slotType) {
        this.slotType = slotType;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * appName.
     *
     * @return the appName
     * @since JDK 1.6
     */
    public String getAppName() {
        return appName;
    }

    /**
     * appName.
     *
     * @param appName the appName to set
     * @since JDK 1.6
     */
    public void setAppName(String appName) {
        this.appName = appName;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
    
    /**
     * sorts.
     *
     * @return the sorts
     * @since JDK 1.6
     */
    public String getSorts() {
        return sorts;
    }

    /**
     * sorts.
     *
     * @param sorts the sorts to set
     * @since JDK 1.6
     */
    public void setSorts(String sorts) {
        this.sorts = sorts;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }
    
    public Long getTagId() {
		return tagId;
	}

	public void setTagId(Long tagId) {
		this.tagId = tagId;
	}

    @Override
    public String toString() {

        return ToStringBuilder.reflectionToString(this);
    }
}
