/**
 * Project Name:ssp-center-api
 * File Name:RemoteBackDataService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月9日下午2:56:43
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;
import java.util.List;

import org.springframework.stereotype.Service;

import cn.com.duiba.tuia.ssp.center.api.dto.BackDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.BackDataSumReqDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteBackDataService <br/>
 * Function: 返回数据. <br/>
 * Date:     2017年6月9日 下午2:56:43 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Service
public interface RemoteBackDataService {
	
	//广告位维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayBySlotIds(Date start, Date end, List<Long> ids, int entranceType);
		
	//媒体维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByAppIds(Date start, Date end, List<Long> ids, int entranceType);
	
	//活动维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActIds(Date start, Date end, List<Long> ids, int entranceType);
	
	//广告位活动维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayBySlotAct(Date startTime,Date endTime,Long slotId,List<Long> activityIds,Integer entranceType);
	
	//活动广告位维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActSlot(Date startTime,Date endTime,Long activityId,List<Long> slotIds, Integer entranceType);
	
	//活动媒体维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActApp(Date startTime,Date endTime,Long activityId,List<Long> appIds, Integer entranceType);
	
	/**
	 * 总计求和数据
	 * @param req
	 * @return
	 */
	DubboResult<BackDataDto> selectSumData(BackDataSumReqDto req);

    /**
     * 根据广告位id列表查询返回发券数据
     * @param start
     * @param end
     * @param slotIds
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDataBySlotIds (Date start, Date end, List<Long> slotIds, Integer entranceType);
    
    /**
     * 根据广告位id列表查询返回发券数据--求和数据
     * @param start
     * @param end
     * @param entranceType
     * @return
     */
    DubboResult<BackDataDto> selectSumBackData(Date start, Date end, List<Long> slotIds, Integer entranceType);

    /**
     * 根据活动id列表查询返回发券数据
     * @param start
     * @param end
     * @param activityIds
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDataByActivityIds(Date start, Date end, List<Long> activityIds, Integer entranceType);
    //求和数据
    DubboResult<BackDataDto> selectSumBackDataByActivityIds(Date start, Date end, List<Long> activityIds, Integer entranceType);


    /**
     * 根据活动id和广告位ids查询返回数据
     * @param start
     * @param end
     * @param activityId
     * @param slotIds
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDataByActivityIdAndSlotIds(Date start, Date end, Long activityId, List<Long> slotIds, Integer entranceType);


    /**
     * 活动-媒体-广告位数据:查询返回返回发券数据
     * @param start
     * @param end
     * @param activityId
     * @param appId
     * @param slotIds
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDataByActivityIdAndAppIdAndSlotIds(Date start, Date end, Long activityId, Long appId ,List<Long> slotIds, Integer entranceType);



    //每日数据

    /**
     *
     * @param start
     * @param end
     * @param slotId
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDailyDataMapBySlotIds(Date start, Date end, Long slotId, Integer entranceType);

    /**
     *
     * @param start
     * @param end
     * @param activityId
     * @param slotId
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDailyDataMapByActivityIdAndSlotId(Date start, Date end, Long activityId ,Long slotId, Integer entranceType);
    
    /**
     * 
     * selectAppBackDataList:(查询app返回数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param appIds
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectAppBackDataList(Date startTime, Date endTime, List<Long> appIds,Integer entranceType);
    //求和数据
    DubboResult<BackDataDto> selectAppBackSumData(Date startTime, Date endTime, List<Long> appIds,Integer entranceType);
    
    /**
     * 
     * selectAppSlotBackList:(查询app广告返回数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param slotIds
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectAppSlotBackList(Date startTime, Date endTime, Long appId,Integer entranceType);

    /**
     * 
     * selectAppBackDailyList:(查询媒体返回每日数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectAppBackDailyList(Date start, Date end, Long appId,Integer entranceType);
    
    /**
     * 
     * selectAppSlotBackDailyList:(查询媒体应用下广告的每日返回数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param appId
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectAppSlotBackDailyList(Date startTime, Date endTime, Long appId,Integer entranceType);
    
    /**
     * 
     * selectActAppBouyDailyList:(查询活动对应的媒体返回每日数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityId
     * @param appId
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectActAppBackDailyList(Date startTime, Date endTime, Long activityId,Long appId,Integer entranceType);
    
    /**
     * 
     * selectActAppBackList:(查询活动对应的媒体返回数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityId
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectActAppBackList(Date startTime, Date endTime, Long activityId,Integer entranceType);

    /**
     * 查询某广告位下 活动维度的数据 <br/>
     *
     * where slot_id = ? and activity_id in (?) and cur_date between group by activity_id
     * @param startTime 开始时间
     * @param endTime 结束时间
     * @param slotId 广告位id
     * @param activityIds 活动id
     * @param entranceType
     * @return List<BuoyDataDto>
     */
    DubboResult<List<BackDataDto>> selectSlotBackByActivityIds(Date startTime, Date endTime, Long slotId, List<Long> activityIds, Integer entranceType);
    
    /**
     * selectBackDailyByActivityIds:(查询活动返回发劵数据). <br/>
     *
     * @author guyan
     * @param startTime
     * @param endTime
     * @param activityIds
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> selectActBackDailyByActivityIds(Date startTime, Date endTime,List<Long> activityIds, Integer entranceType);
}


