package cn.com.duiba.tuia.ssp.center.api.remote;
/**
 * Project Name:tuia-ssp-center<br>
 * File Name:<br>
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote<br>
 * Date:2017年09月11日下午5:04<br>
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.<br>
 */

import cn.com.duiba.tuia.ssp.center.api.dto.ReqSdkVersionDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SdkVersionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName: RemoteSdkVersionService <br/>
 * Function:  <br/>
 * Date: 2017年09月11日 下午5:04 <br/>
 *
 * @author Dozening
 * @see
 * @since JDK 1.6
 */
public interface RemoteSdkVersionService {

    /**
     * 新增sdk打包记录
     * @param dto
     * @return
     */
    DubboResult <Integer> insert(SdkVersionDto dto);

    /***
     * getLastVersionId:获取sdk最新包序号.
     * @param sdkType
     * @return
     */
    DubboResult <Long> getLastVersionId(Integer sdkType);

    /***
     * 获取sdk最新包序号
     * @param id
     * @return
     */
    DubboResult <Integer> delSdkVersion(Long id);


    /***
     * 设置sdk包下载地址
     * @param id
     * @param sdkPackageUrl
     * @return
     */
    DubboResult <Integer> updatePackageUrl(Long id, String sdkPackageUrl);

    /***
     * 设置sdk文档地址
     * @param id
     * @param sdkDocUrl
     * @param sdkPdfUrl
     *
     */
    DubboResult <Integer> updateSdkDocUrl(Long id, String sdkDocUrl, String sdkPdfUrl);

    /***
     * 设置sdk备注信息
     * @param id
     * @param sdkRemark
     * @return
     */
    DubboResult <Integer> updateSdkRemark(Long id, String sdkRemark);

    /***
     * 查询sdk打包信息总数
     * @param reqSdkVersionDto
     * @return
     */
    DubboResult <Integer> listCount(ReqSdkVersionDto reqSdkVersionDto);

    /***
     * 分页查询sdk版本信息
     * @param reqSdkVersionDto
     * @return
     */
    DubboResult <List<SdkVersionDto>>list(ReqSdkVersionDto reqSdkVersionDto);

    /**
     * 获取当前的发布版本
     * @param reqSdkVersionDto
     * @return
     */
    DubboResult <List<SdkVersionDto>>getReleaseDto(ReqSdkVersionDto reqSdkVersionDto);

    /**
     * 发布
     * @param reqSdkVersionDto
     * @return
     */
    DubboResult <Integer>release(ReqSdkVersionDto reqSdkVersionDto);
}
