package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.ShieldDomainDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ShieldDomainSlotDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

public interface RemoteShieldDomainSlotService {

    /**
     * 如果广告位对应的屏蔽策略已存在不会插入
     * @param slotIds 广告位ID集合
     * @param shieldId 屏蔽域名策略ID
     * @return 成功插入条数
     */
    DubboResult<Integer> insert(List<Long> slotIds, Long shieldId);

    /**
     *
     * @param ids 要删除记录的ID集合
     * @return 成功删除条数
     */
    DubboResult<Integer> deleteByIds(List<Long> ids);

    /**
     *
     * @param shieldIds 要删除记录的屏蔽策略ID集合
     * @return 成功删除条数
     */
    DubboResult<Integer> deleteByShieldIds(List<Long> shieldIds);

    /**
     *
     * @param shieldId 屏蔽策略对应的ID
     * @return 屏蔽策略对应的广告位
     */
    DubboResult<List<ShieldDomainSlotDto>> selectListByShieldId(Long shieldId);

    /**
     * 查询广告位所有的屏蔽域名
     * @param slotId 广告位ID
     * @return
     */
    DubboResult<List<ShieldDomainDto>> selectShieldDomainBySlotId(Long slotId);

}
