/**
 * Project Name:media-api<br>
 * File Name:ActivityStatisticsDayDto.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.dto<br>
 * Date:2016年10月18日上午10:41:31<br>
 * Copyright (c) 2016; duiba.com.cn All Rights Reserved.<br>
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: ActivityStatisticsDayDto <br/>
 * Function: 活动统计维度表. <br/>
 * date: 2016年10月18日 上午10:41:31 <br/>
 *
 * @author leiliang
 * @version
 * @since JDK 1.6
 */
public class ActivityStatisticsDayDto extends BaseDto {

    /** The Constant serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /**
     * 媒体用户id.
     */
    private Long              mediaId;

    /** 媒体id. */
    private Long              appId;

    /** 兑吧活动类型. */
    private Integer           duibaActivityType;

    /** 兑吧活动ID(在管理端页面展示). */
    private Long              duibaActivityId;

    /** 活动id(给媒体分配活动后生成的ID). */
    private Long              activityId;

    /** 每日曝光数. */
    private long              exposureCount;

    /** 每日点击数. */
    private long              clickCount;

    /** 活动UV. */
    private long              activityUv;

    /** 活动参与次数. */
    private long              involveCounts;

    /** 活动参与人数. */
    private long              participantCounts;

    /** 活动请求广告次数. */
    private long              requestAdvertCount;

    /** 活动发券. */
    private long              launchAdvertCount;

    /** 广告点击量. */
    private long              clickAdvertCount;

    /** 每日消费(分). */
    private long              consumeTotal;

    /** 当天日期，例：2016-04-08. */
    private String            curDate;
    
    /** 活动来源 0-兑吧活动 1-推啊活动 2-流量引导页 */
    private Integer           source;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getDuibaActivityType() {
        return duibaActivityType;
    }

    public void setDuibaActivityType(Integer duibaActivityType) {
        this.duibaActivityType = duibaActivityType;
    }

    public Long getDuibaActivityId() {
        return duibaActivityId;
    }

    public void setDuibaActivityId(Long duibaActivityId) {
        this.duibaActivityId = duibaActivityId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public long getExposureCount() {
        return exposureCount;
    }

    public void setExposureCount(long exposureCount) {
        this.exposureCount = exposureCount;
    }

    public long getClickCount() {
        return clickCount;
    }

    public void setClickCount(long clickCount) {
        this.clickCount = clickCount;
    }

    public long getActivityUv() {
        return activityUv;
    }

    public void setActivityUv(long activityUv) {
        this.activityUv = activityUv;
    }

    public long getInvolveCounts() {
        return involveCounts;
    }

    public void setInvolveCounts(long involveCounts) {
        this.involveCounts = involveCounts;
    }

    public long getParticipantCounts() {
        return participantCounts;
    }

    public void setParticipantCounts(long participantCounts) {
        this.participantCounts = participantCounts;
    }

    public long getRequestAdvertCount() {
        return requestAdvertCount;
    }

    public void setRequestAdvertCount(long requestAdvertCount) {
        this.requestAdvertCount = requestAdvertCount;
    }

    public long getLaunchAdvertCount() {
        return launchAdvertCount;
    }

    public void setLaunchAdvertCount(long launchAdvertCount) {
        this.launchAdvertCount = launchAdvertCount;
    }

    public long getClickAdvertCount() {
        return clickAdvertCount;
    }

    public void setClickAdvertCount(long clickAdvertCount) {
        this.clickAdvertCount = clickAdvertCount;
    }

    public long getConsumeTotal() {
        return consumeTotal;
    }

    public void setConsumeTotal(long consumeTotal) {
        this.consumeTotal = consumeTotal;
    }

    public String getCurDate() {
        return curDate;
    }

    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    
    public Integer getSource() {
        return source;
    }

    
    public void setSource(Integer source) {
        this.source = source;
    }

}
