/**
 * Project Name:ssp-center-api
 * File Name:RemoteSlotFlowDailyStatService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年9月21日上午10:35:29
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotFlowStatDailyByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotFlowDailyStatDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteSlotFlowDailyStatService <br/>
 * Function: 广告位流量引导页. <br/>
 * Date:     2017年9月21日 上午10:35:29 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface RemoteSlotFlowDailyStatService {
   
    /**
    * 
    * getSlotFlowDailyData:(查询广告位流量引导页每日数据). <br/>
    *
    * @author guyan
    * @param req
    * @return
    * @since JDK 1.6
    */
   DubboResult<List<SlotFlowDailyStatDto>> getSlotFlowDailyList(ReqSlotFlowStatDailyByPage req);
   
   /**
    * 
    * getSlotFlowDailyCount:(查询广告位流量引导页条数). <br/>
    *
    * @author guyan
    * @param req
    * @return
    * @since JDK 1.6
    */
   DubboResult<Integer> getSlotFlowDailyCount(ReqSlotFlowStatDailyByPage req);
   
   /**
    * 
    * getSlotFlowDailySum:(查询广告位流量引导页每日数据总计). <br/>
    *
    * @author guyan
    * @param req
    * @return
    * @since JDK 1.6
    */
   DubboResult<SlotFlowDailyStatDto> getSlotFlowDailySum(ReqSlotFlowStatDailyByPage req);
   
   
   /**
    * 
    * getFlowDailyCount:(查询流量引导页总计). <br/>
    *
    * @author guyan
    * @param req
    * @return
    * @since JDK 1.6
    */
   DubboResult<Integer> getFlowDailyCount(ReqSlotFlowStatDailyByPage req);
   
   
   /**
    * 
    * getFlowDailyList:(查询流量引导页每日数据). <br/>
    *
    * @author guyan
    * @param req
    * @return
    * @since JDK 1.6
    */
   DubboResult<List<SlotFlowDailyStatDto>> getFlowDailyList(ReqSlotFlowStatDailyByPage req);
   
}

