package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;
import java.util.Map;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialCtrDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMaterialSpecificationDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspMaterialSpecificationDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
@AdvancedFeignClient
public interface RemoteMaterialSpecificationBackendService {

    /**
     * 查询广告规格列表
     * 
     * @param req 查询条件
     * @return 广告规格列表
     */
    DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req);
    
    //规格id获取title，不使用返回对象方法，减小网络交互数据流大小
    DubboResult<String> getTitleById(Long msId);

    /**
     * 删除规格
     * 
     * @param id 规格ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteMaterialSpecification(Long id);

    /**
     * 获取规格明细
     * 
     * @param msId 规格ID
     * @return 规格明细
     */
    DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId);

    /**
     * 添加/更新规格
     * 
     * @param req 规格
     * @return Boolean
     */
    DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req);

    /**
     * 规格定向
     * 
     * @param msId 规格ID
     * @param appIds 媒体ID列表
     * @param directStatus
     * @return Boolean
     */
    DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus);

    /**
     * 获取规格定向的媒体列表
     * 
     * @param msId 规格ID
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getMsDirectedMediaApp(Long msId);

    /**
     * 通过ID列表获取规格名称列表
     * 
     * @param ids 规格ID列表
     * @return MAP
     */
    DubboResult<Map<Long, String>> getMsNameByIds(List<Long> ids);

    /**
     * 查询某广告位下某活动的素材列表，按CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return CTR素材列表
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotActivity(Long slotId, Long activityId,
                                                                   Integer source);
    
    /**
     * 查询某广告位下某活动的素材列表，按CTR排序
     * 
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @return CTR素材列表
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotActivityBySource(Long slotId, Long activityId,
                                                                           Integer source);

    /**
     * 新素材曝光量达2000后更改状态
     *
     * @param materialId 素材ID
     * @return Boolean
     */
    DubboResult<Boolean> changeMsItemContentStatus(Long materialId);

    /**
     * getMsImageUrl:(获取素材地址). <br/>
     *
     * @param msId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long, String>> getMsImageUrl(List<Long> msId);
    
    //获取素材库图片地址
    DubboResult<Map<Long, String>> getSckImageUrl(List<Long> sckIds);

    /**
     * getMsIdByName:(通过广告位规格查询广告位规格ID). <br/>
     *
     * @param msName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getMsIdByName(String msName);
    
    /**
     * 
     * 通过广告位ID 查询活动素材ctr
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotId(Long slotId);

    DubboResult<List<RspMaterialSpecificationDto>> getByIds(List<Long> ids);

    DubboResult<List<Long>> getMsIdsExceptTheMediaApp(Long mediaId);

    DubboResult<List<Long>> getMsIdsByMediaApp(Long mediaId);
}
