package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotScopeConfig;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotScopeConfigDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteSlotScopeConfigService {

    /**
     * 插入一条合理配置
     * @param dto
     * @return 成功插入主键ID
     */
    Long insert(SlotScopeConfigDto dto);

    /**
     *  更新一条合理配置
     * @param dto
     * @return 成功更新条数
     */
    Integer update(SlotScopeConfigDto dto);

    /**
     * 查询广告位对应的合理配置
     * @param slotId 广告位ID
     * @return
     */
    SlotScopeConfigDto selectBySlotId(Long slotId);

    /**
     *  广告位对应的配置，广告位的配置可能不存在
     * @param slotIds 广告位Id集合
     * @return
     */
    List<SlotScopeConfigDto> selectBySlotIds(List<Long> slotIds);

    /**
     * 管理端搜索查询
     * @param req
     * @return
     */
    List<SlotScopeConfigDto> selectByPage(ReqSlotScopeConfig req);
}
