/**
 * Project Name:media-api File Name:RemoteMediaAppService.java Package Name:cn.com.duiba.tuia.media.api.remoteservice
 * Date:2016年9月30日下午3:48:58 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.IdAndNameDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaAppStatusDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaAppVerifyStatusDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppService <br/>
 * Function: tuia媒体app信息服务. <br/>
 * Date: 2016年9月30日 下午3:48:58 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@AdvancedFeignClient
public interface RemoteMediaAppBackendService {
	
	/**
     * updateMediaAppStatus:(修改媒体应用信息状态). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppDto> updateMediaAppStatus(ReqUpdateMediaAppStatusDto param);
    
    /**
     * updateMediaAppStatus:(修改媒体应用信息验证状态). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateMediaAppVerifyStatus(ReqUpdateMediaAppVerifyStatusDto verifyStatusDto);

    /**
     * getMediaApp:(查看媒体应用信息状态). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppDto> getMediaApp(Long appId);

    /**
     * 设置媒体应用ID和名称缓存.
     *
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> getAllAppIdAndName();

    /**
     * 删除媒体应用ID和名称缓存.
     *
     * @return the dubbo result< boolean>
     */
    DubboResult<Boolean> delAllAppIdAndName();

    /**
     * 更具媒体应用名称模糊查询媒体应用ID.
     *
     * @param name the name
     * @return the app ids by name
     */
    DubboResult<List<Long>> getAppIdsByName(String name);

    /**
     * 通过媒体ID查询媒体名称.
     *
     * @param appId the app id
     * @return the app name by id
     */
    DubboResult<String> getAppNameById(Long appId);

    /**
     * 根据媒体ID列表查询媒体
     * 
     * @param ids
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getMediaAppByIds(List<Long> ids);

    /**
     * getMediaAppCacheById:(通过媒体ID查询媒体信息). <br/>
     *
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppDataDto> getMediaAppCacheById(Long mediaId);
    
    /**
     * 
     * 通过媒体App 名称查询媒体app list
     *
     * @author guyan
     * @param appName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MediaAppDto>> getMediaAppListByName(String appName);
    
    
    /**
     * 通过mediaIds查询appIds
     * @param mediaIds
     * @return
     */
    public DubboResult<List<IdAndNameDto>> selectAppIdsByMediaIds(List<Long> mediaIds);
    
    /**
     * 
     * 修改媒体冻结状态
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    public DubboResult<Boolean> updateAppFrozenStatus(ReqUpdateMediaAppStatusDto param);
}
