package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ChargeHistoryDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqChargeHistory;

import java.util.List;

@AdvancedFeignClient
public interface RemoteChargeHistoryService {

    /**
     * 插入一条历史记录
     * @param dto
     * @return 插入成功生成的ID
     */
    Long insert(ChargeHistoryDto dto);

    /**
     * 更新一条历史记录
     * @param dto
     * @return 更新成功条数
     */
    Integer update(ChargeHistoryDto dto);


    List<ChargeHistoryDto> selectList(ReqChargeHistory req);

    Integer selectListCount(ReqChargeHistory req);

    ChargeHistoryDto selectById(Long id);

    Integer updateHistoryType();
}
