package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainInfoDto;
import cn.com.duiba.tuia.ssp.center.api.dto.GlobalDomainInfoDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteDomainInfoService {

    DubboResult<DomainInfoDto> selectDomainBySlotId(Long slotId);

    DubboResult<Integer> selectCountByStrategyId(Long strategyId);

    DubboResult<List<Long>> selectSlotIdsByStrategyId(Long strategyId);

    DubboResult<Integer> deleteByStrategyId(Long strategyId);

    DubboResult<Integer> insert(List<Long> slotIds, Long strategyId);

    /**
     *
     * @param slotIds 广告位id集合
     * @param strategyId 关联策略id
     * @return 所有已经关联了其他策略的广告位
     */
    DubboResult<List<Long>> selectSlotIdsIsExist(List<Long> slotIds, Long strategyId);

    /**
     * 活动线专用接口
     * @param slotId 广告位ID
     * @return 广告位配置的落地页域名，中间页暂不支持，如果未配置广告位维度则返回全局配置落地页域名,本接口直接查库，调用方根据调用量自行缓存
     */
    DubboResult<GlobalDomainInfoDto> selectLandAndMidUrlBySlotId(Long slotId);
}
