/**
 * Project Name:media-api<br>
 * File Name:RemoteMediaBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日上午9:34:24<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqGetAccountByPageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateFinanceDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspAccountBaseDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName: RemoteMediaBackendService <br/>
 * date: 2016年10月10日 上午9:34:24 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@AdvancedFeignClient
public interface RemoteMediaBackendService {

    /**
     * 分页查询媒体账户数据.
     *
     * @param req the req
     * @return the medias by page
     */
    DubboResult<PageResultDto<RspAccountBaseDto>> getMediasByPage(ReqGetAccountByPageDto req);

    /**
     * 查询媒体账户信息.
     *
     * @param mediaId the media id
     * @return the media by media id
     */
    DubboResult<AccountDto> getMediaByMediaId(Long mediaId);

    DubboResult<Boolean> updateFreezeStatus(Long mediaId, Integer status);

    /**
     * selectAccountByEmail:(通过email查询媒体用户信息). <br/>
     *
     * @param email
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountDto> selectAccountByEmail(String email);

    /**
     * selectAccountByIds:(通过媒体用户id集合查询用户信息). <br/>
     *
     * @param mediaIds
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountDto>> selectAccountByIds(List<Long> mediaIds);

    /**
     * selectAccountCacheById:(通过用户ID从缓存查询用户信息). <br/>
     *
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountDto> selectAccountCacheById(Long mediaId);
    
    /**
     * 
     * updateFinanceObjectMsg:(更新财务对象信息). <br/>
     *
     * @author guyan
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateFinanceObjectMsg(ReqUpdateFinanceDto param);

}
