/**
 * Project Name:ssp-center-api
 * File Name:RspManagerShieldStrategy.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年8月21日下午3:33:02
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:RspManagerShieldStrategy <br/>
 * Function: 管理端屏蔽标签信息. <br/>
 * Date:     2017年8月21日 下午3:33:02 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class RspManagerShieldStrategy implements Serializable  {

    /**序列号*/
    private static final long serialVersionUID = -6151446921677622415L;
    
    /**管理端屏蔽策略标签ID*/
    private Long              managerStrategyId;
    
    /** 管理端屏蔽行业. */
    private List<TagLevel>    managerShieldIndustries;
    /** 广告线 行业屏蔽标签（逗号分隔）**/
    private String advertIndustriesTag;

    /** 管理端屏蔽广告主. */
    private List<String>      managerShieldAdvertisers;

    /** 管理端屏蔽广告列表. */
    private List<TagLevel>    managerAdvertTagNums;
    /** 广告线 广告屏蔽标签（逗号分隔） **/
    private String advertSlotTag;

    /** 管理端屏蔽活动标签列表 */
    private List<TagLevel>    managerShieldActivitys;

    /** 管理端是否屏蔽行业状态. */
    private boolean           managerIndustryFlag      = false;

    /** 管理端是否屏蔽广告主状态. */
    private boolean           managerAdvertiserFlag    = false;

    /** 管理端是否屏蔽广告状态. */
    private boolean           managerAdvertTagNumsFlag = false;
    
    /** 管理端是否屏蔽活动标签状态. */
    private boolean           managerActivitysFlag     = false;
    
    
    
    public Long getManagerStrategyId() {
        return managerStrategyId;
    }

    
    public void setManagerStrategyId(Long managerStrategyId) {
        this.managerStrategyId = managerStrategyId;
    }

    
    public List<TagLevel> getManagerShieldIndustries() {
        return managerShieldIndustries;
    }

    
    public void setManagerShieldIndustries(List<TagLevel> managerShieldIndustries) {
        this.managerShieldIndustries = managerShieldIndustries;
    }

    
    public List<String> getManagerShieldAdvertisers() {
        return managerShieldAdvertisers;
    }

    
    public void setManagerShieldAdvertisers(List<String> managerShieldAdvertisers) {
        this.managerShieldAdvertisers = managerShieldAdvertisers;
    }

    
    public List<TagLevel> getManagerAdvertTagNums() {
        return managerAdvertTagNums;
    }

    
    public void setManagerAdvertTagNums(List<TagLevel> managerAdvertTagNums) {
        this.managerAdvertTagNums = managerAdvertTagNums;
    }

    
    public List<TagLevel> getManagerShieldActivitys() {
        return managerShieldActivitys;
    }

    
    public void setManagerShieldActivitys(List<TagLevel> managerShieldActivitys) {
        this.managerShieldActivitys = managerShieldActivitys;
    }

    
    public boolean isManagerIndustryFlag() {
        return managerIndustryFlag;
    }

    
    public void setManagerIndustryFlag(boolean managerIndustryFlag) {
        this.managerIndustryFlag = managerIndustryFlag;
    }

    
    public boolean isManagerAdvertiserFlag() {
        return managerAdvertiserFlag;
    }

    
    public void setManagerAdvertiserFlag(boolean managerAdvertiserFlag) {
        this.managerAdvertiserFlag = managerAdvertiserFlag;
    }

    
    public boolean isManagerAdvertTagNumsFlag() {
        return managerAdvertTagNumsFlag;
    }

    
    public void setManagerAdvertTagNumsFlag(boolean managerAdvertTagNumsFlag) {
        this.managerAdvertTagNumsFlag = managerAdvertTagNumsFlag;
    }

    
    public boolean isManagerActivitysFlag() {
        return managerActivitysFlag;
    }

    
    public void setManagerActivitysFlag(boolean managerActivitysFlag) {
        this.managerActivitysFlag = managerActivitysFlag;
    }

    public String getAdvertIndustriesTag() {
        return advertIndustriesTag;
    }

    public void setAdvertIndustriesTag(String advertIndustriesTag) {
        this.advertIndustriesTag = advertIndustriesTag;
    }

    public String getAdvertSlotTag() {
        return advertSlotTag;
    }

    public void setAdvertSlotTag(String advertSlotTag) {
        this.advertSlotTag = advertSlotTag;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

