package cn.com.duiba.tuia.ssp.center.api.constant;

public class RedisKeyConstant {

	private static final String PREFIX = "TSW_";
	
	/** 活动类型和活动类型中文KEY */
	private static final String ACT_AND_NAME_KEY = "K00_";
    
    /** 活动类型和活动类型中文KEY */
	private static final String ALL_ACT_AND_NAME_KEY = "K01_";
    
    /** 媒体应用的ID和名称集合标识. */
	private static final String APPID_AND_NAME_KEY   = "K02_";
	
	/** 广告位ID和广告位名称集合标示 */
	private static final String SOLTID_AND_NAME_KEY  = "K03_";
	
	/** 屏蔽策略标识. */
	private static final String STRATEGY_KEY = "K04_";
	
	/** 媒体标识. */
	private static final String MEDIA_APP_BY_KEY = "K05_";
	
	/** 广告位标识. */
	private static final String SLOT_KEY = "K06_";
	
	/** 活动定向媒体标识 --type*/
	private static final String ACTIVITY_DIRECT_APP_KEY = "K07_";
	
	/** 活动定向媒体标识--source */
	private static final String ACTIVITY_SOURCE_DIRECT_APP_KEY = "K08_";
	
	/** 媒体用户状态标识. */
	private static final String MEDIA_STATUS_KEY = "K09_";
	
	/** 媒体标识. */
	private static final String MEDIA_APP_KEY = "K10_";
	
	/** 媒体用户标识 */
	private static final String MEDIA_ACOUNT_KEY = "K11_";
	
	/** 活动标识 */
//	private static final String ACTIVITY_KEY = "K12_";
	
	/** 修改邮件验证码标识. */
	private static final String REPLACE_EMAIL_KEY = "K13_";
	
	/** 找回密码邮件验证码标识. */
	private static final String RESETPD_EMAIL_KEY = "K14_";
	
	/** 短信缓存标识. */
	private static final String SMS_KEY = "K15_";
	
	/** 活动标识 */
	private static final String ACTIVITY_KEY = "K16_";
	
	/** 活动关联广告标识 */
	private static final String ACTIVITY_ADVERT_KEY  = "K17_";
	
	/** 活动关联广告标识 (根据活动来源)*/
	private static final String ACTIVITY_SOURCE_ADVERT_KEY  = "K18_";
    
    /**
     * 活动类型和活动类型中文KEY <br/>
     *
     * @param actType
     * @return
     */
    public static String getActTypeAndNameKey(String actType) {
        return PREFIX + ACT_AND_NAME_KEY + actType;
    }
    
    /**
     * 获取所有活动类型和活动类型中文KEY <br/>
     *
     * @return
     */
    public static String getAllActTypeAndNameKey() {
        return PREFIX + ALL_ACT_AND_NAME_KEY;
    }
    
    /**
     * 媒体应用的ID和名称集合标识.
     *
     * @param appId the app id
     * @return the app id and name key
     */
    public static String getAppIdAndNameKey(long appId) {
        return PREFIX + APPID_AND_NAME_KEY + appId;
    }
    
    /**
     * 广告位ID和广告位名称集合标示 <br/>
     *
     * @param slotId
     * @return
     */
    public static String getSlotIdAndNameKey(long slotId) {
        return PREFIX + SOLTID_AND_NAME_KEY + slotId;
    }
    
    /**
     * 获取屏蔽策略缓存标识.
     *
     * @param strategyId 屏蔽策略ID
     * @return the strategy key
     */
    public static String getStrategyKey(long strategyId) {
        return PREFIX + STRATEGY_KEY + strategyId;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param appKey app key
     * @return the media app key
     */
    public static String getMediaAppByKey(String appKey) {
        return PREFIX + MEDIA_APP_BY_KEY + appKey;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param slotId the slot id
     * @return the media app strategy key
     */
    public static String getSlotKey(long slotId) {
        return PREFIX + SLOT_KEY + slotId;
    }
    
    /**
     * 获取活动定向媒体的KEY
     * 
     * @param activityId
     * @param activityType
     * @return KEY
     */
    public static String getActivity_direct_app_key(Long activityId, Integer activityType) {
        return PREFIX + ACTIVITY_DIRECT_APP_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }
    
    /**
     * 获取活动(来源)定向媒体的KEY
     * 
     * @param activityId
     * @param source
     * @return KEY
     */
    public static String getActivityDirectAppKeyBySource(Long activityId, Integer source) {
        return PREFIX + ACTIVITY_SOURCE_DIRECT_APP_KEY + activityId + SplitConstant.SPLIT_HYPHEN + source;
    }
    
    /**
     * 获取媒体用户状态缓存标识.
     *
     * @param mediaId 媒体ID
     * @return the media status key
     */
    public static String getMediaStatusKey(long mediaId) {
        return PREFIX + MEDIA_STATUS_KEY + mediaId;
    }
    
    /**
     * 获取媒体缓存标识.
     *
     * @param mediaAppId 媒体ID
     * @return the media app key
     */
    public static String getMediaAppKey(long mediaAppId) {
        return PREFIX + MEDIA_APP_KEY + mediaAppId;
    }
    
    /**
     * getMediaAccountByKey:(通过key查询缓存中的媒体用户信息). <br/>
     *
     * @param mediaId
     * @return
     */
    public static String getMediaAccountByKey(Long mediaId) {
        return PREFIX + MEDIA_ACOUNT_KEY + mediaId;
    }
    
    /**
     * 获取活动缓存标识.
     *
     * @param activityKey activity key
     * @return the activity key
     *//*
    public static String getActivityByKey(String activityKey) {
        return PREFIX + ACTIVITY_KEY + activityKey;
    }*/
    
    /**
     * 获取更好邮箱的邮件验证码标识.
     *
     * @param userId the user id
     * @param token the token
     * @return the email key
     */
    public static String getReplaceEmailKey(Long userId, String token) {
        return PREFIX + REPLACE_EMAIL_KEY + userId + '-' + token;
    }
    
    /**
     * 获取邮件验证码标识.
     *
     * @param userEmail 邮箱
     * @return the email key
     */
    public static String getResetPwEmailKey(String userEmail) {
        return PREFIX + RESETPD_EMAIL_KEY + userEmail;
    }
    
    /**
     * 获取短信缓存标志.
     *
     * @param phone 手机号
     * @param type 类型
     * @return the sms key
     */
    public static String getSmsKey(String phone, int type) {
        return PREFIX + SMS_KEY + phone + "-" + type;
    }
    
    /**
     * 获取活动缓存标识.
     *
     * @param activityKey activity key
     * @return the activity key
     */
    public static String getActivityByKey(String activityKey) {
        return PREFIX + ACTIVITY_KEY + activityKey;
    }
    
    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param activityType
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKey(Long activityId, Integer activityType) {
        return PREFIX + ACTIVITY_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + activityType;
    }
    
    /**
     * 获取活动定制广告缓存标识
     *
     * @param activityId
     * @param source
     * @return the activityAdvertKey
     */
    public static String getActivityAdvertByKeyAndSource(Long activityId, Integer source) {
        return PREFIX + ACTIVITY_SOURCE_ADVERT_KEY + activityId + SplitConstant.SPLIT_HYPHEN + source;
    }
}
