/**
 * Project Name:media-api File Name:RemoteMediaAppConfigService.java Package
 * Name:cn.com.duiba.tuia.media.api.remoteservice Date:2016年10月8日下午2:56:34 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqGetMediaAppConfigByPageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqUpdateMediaAppConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.RspMediaAppConfigDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteMediaAppConfigService <br/>
 * Function: tuia媒体app配置信息. <br/>
 * Date: 2016年10月8日 下午2:56:34 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public interface RemoteMediaAppConfigBackendService {

    /**
     * 
     * getMediaAppConfigByPage:(媒体配置信息分页). <br/>
     *
     * @author ZFZ
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<PageResultDto<RspMediaAppConfigDto>> getMediaAppConfigByPage(ReqGetMediaAppConfigByPageDto req);

    /**
     * 
     * getMediaAppConfig:(查看媒体配置信息). <br/>
     *
     * @author ZFZ
     * @param mediaAppId
     * @return
     * @since JDK 1.6
     */
    DubboResult<MediaAppConfigDto> getMediaAppConfig(Long mediaAppId);

    /**
     * 
     * updateMediaAppConfig:(修改媒体配置信息). <br/>
     *
     * @author ZFZ
     * @param param
     * @return
     * @since JDK 1.6
     */
    DubboResult<Boolean> updateMediaAppConfig(ReqUpdateMediaAppConfigDto param);

    DubboResult<Integer> insert(MediaAppConfigDto mediaAppConfigDto);
}
