package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.MediaPersonalMsgDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 媒体个人信息及财务信息
 */
public interface RemoteMediaPersonMsgService {
    /**
     * 媒体用户修改个人信息
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> updatePersonalMsg(MediaPersonalMsgDto dto);

    /**
     * 通过媒体账户ID查询财务信息下个人信息
     *
     * @param mediaId
     * @return
     */
    DubboResult<MediaPersonalMsgDto> selectPersonalMsgById(Long mediaId);

    /**
     * 通过媒体ID集合，批量查询财务信息
     * @param mediaIds
     * @return
     */
    DubboResult<List<MediaPersonalMsgDto>> selectPersonalMsgListMsgByIds(List<Long> mediaIds);

    /**
     * 新增用户个人信息
     *
     * @param dto
     * @return
     */
    DubboResult<Boolean> insertPersonalMsg(MediaPersonalMsgDto dto);
}
