package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActRatioRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityRatioDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteActRatioService {
	/**
	 * 
	 * @param slotId
	 * @param actId
	 * @param actSource
	 * @return
	 */
	Long addGroup(Long slotId, Long actId, Integer actSource);
	/**
	 * 
	 * @param slotId
	 * @return
	 */
	List<ActRatioRsp> listAct4Slot(Long slotId);
	/**
	 * 
	 * @param slotId
	 * @return
	 */
	List<ActivityRatioDto> listAct4Dayu(Long slotId);
	/**
	 * 
	 * @param record
	 */
	DubboResult<Boolean> addAct(ActivityRatioDto record);
	
	Long getSceneId(Long slotId);
	/**
	 * 
	 * @param record
	 */
	void delAct(ActivityRatioDto record);
	/**
	 * 
	 * @param actGroupId
	 */
	void delGroup(Long actGroupId);
	/**
	 * 修改比例
	 * @param record
	 */
	DubboResult<Boolean> updateRatio(ActivityRatioDto record);
	
	void sort(Long slotId, Long actGroupId, Integer location);
}
