package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.tuia.ssp.center.api.dto.RspMaterialSpecificationDto;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.web.bind.annotation.RequestMapping;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivityDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ActivitySpmDto;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaAppDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqActivityDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqIdAndType;
import cn.com.duiba.tuia.ssp.center.api.dto.RspActivityDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author xuyenan
 * @createTime 2016/10/25
 */
@AdvancedFeignClient
public interface RemoteActivityBackendService {

    /**
     * getByActivityIds:(查询活动接口). <br/>
     *
     * @author ZFZ
     * @param activityIds 查询条件
     * @param actSource 活动来源
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<RspActivityDto>> getByActivityIds(List<Long> activityIds, int actSource, Map<Integer, String> actTypeMap);

    /**
     * 给活动推荐使用的接口，根据活动id和Type查找活动,status=1，isDelete=0
     *
     * @param id 活动ID
     * @param type 活动类型
     * @return 活动名称
     */
    DubboResult<String> getActivityNameByIdAndType(Long id, Integer type);
    
    /**
     * 给活动推荐使用的接口，根据活动id和Source查找活动,status=1，isDelete=0
     *
     * @param id 活动ID
     * @param source 活动来源
     * @return 活动名称
     */
    DubboResult<String> getActivityNameByIdAndSource(Long id, Integer source);

    /**
     * 发布活动计划
     *
     * @param activities 活动：id+type
     * @param actSource 活动来源 0-兑吧 1-推啊
     * @return Boolean
     */
    DubboResult<Boolean> addActivityPlan(List<ReqIdAndType> activities, Integer actSource);
    
    /**
     * 查询所有关联该活动的广告位id
     * @param activitiyId
     * @param actSource
     * @return
     */
    DubboResult<Set<Long>> getInfo4CloseAct(Long activitiyId, Integer actSource);

    /**
     * 删除活动计划
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    DubboResult<Boolean> deleteActivityPlanBySource(Long activityId, Integer source);
    
    //删除活动计划新接口，活动下广告位排序遍历
    DubboResult<Boolean> deleteActivityPlanBySourceNew(Long activityId, Integer source);
    
    /**
     * 删除活动计划
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    DubboResult<Boolean> deleteActivityPlan(Long activityId, Integer activityType);

    /**
     * 编辑活动计划
     *
     * @param reqActivityDto
     * @return Boolean
     */
    DubboResult<Boolean> updateActivityPlan(ReqActivityDto reqActivityDto);

    /**
     * 获取活动定向的媒体
     * 
     * @param activityId
     * @param source
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaAppBySource(Long activityId, Integer source);
    
    /**
     * 获取活动定向的媒体
     * 
     * @param activityId
     * @param activityType
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getActivityDirectedMediaApp(Long activityId, Integer activityType);

    /**
     * 活动媒体定向
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param source 活动来源
     * @param directStatus 是否开启定向
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    @RequestMapping("/activityDirectToMediaApp2")
    DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType,Integer source, Integer directStatus, List<Long> appIds);
    
    /**
     * 活动媒体定向
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 是否开启定向
     * @param appIds 媒体ID列表
     * @return Boolean
     */
    @RequestMapping("/activityDirectToMediaApp1")
    DubboResult<Boolean> activityDirectToMediaApp(Long activityId, Integer activityType, Integer directStatus, List<Long> appIds);

    /**
     * 活动定制广告
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @param directStatus 是否开启定制
     * @param directMode 定向模式
     * @param advertIds 广告ID列表
     * @return Boolean
     */
    DubboResult<Boolean> activityDirectToAdvertBySource(Long activityId, Integer source, Integer directStatus, Integer directMode, List<Long> advertIds,Integer activityType);
    
    /**
     * 活动定制广告
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @param directStatus 是否开启定制
     * @param directMode 定向模式
     * @param advertIds 广告ID列表
     * @return Boolean
     */
    DubboResult<Boolean> activityDirectToAdvert(Long activityId, Integer activityType, Integer directStatus, Integer directMode, List<Long> advertIds);

    /**
     * 查询活动关联广告，给引擎提供的接口
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return 广告ID列表
     */
    DubboResult<List<Long>> getActivityAdvertIds(Long activityId, Integer activityType);

    /**
     * 查询某个活动在某个广告位下的SPM值
     * 
     * @param slotId 广告位ID
     * @param statType 统计维度
     * @return 活动SPM
     */
    DubboResult<List<ActivitySpmDto>> getSlotSpm(Long slotId, Integer statType);

    /**
     * 将活动从试投列表中移除
     * 
     * @param activityId 活动ID
     * @param source 活动来源
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActListBySource(Long activityId, Integer source);
    
    /**
     * 将活动从试投列表中移除
     * 
     * @param activityId 活动ID
     * @param activityType 活动类型
     * @return Boolean
     */
    DubboResult<Boolean> removeFromNewActList(Long activityId, Integer activityType);
    
    /**
     * 
     * getCacheActivityName:(查询活动名称). <br/>
     *
     * @param activities 活动ID+活动类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long,String>> getCacheActivityNameBySource(List<ReqIdAndType> activities);
    
    /**
     * 
     * getCacheActivityName:(查询活动名称). <br/>
     *
     * @param activities 活动ID+活动类型
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long,String>> getCacheActivityName(List<ReqIdAndType> activities);
    
    /**
     * 
     * getActivityIdsByName:(通过活动名称查询活动IDS). <br/>
     *
     * @param activityName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getActivityIdsByName(String activityName);

    /**
     * 开启/关闭活动计划
     *
     * @param activityId
     * @param source
     * @param enableStatus
     * @return Boolean
     */
    DubboResult<Boolean> changeActivityPlanEnableBySource(Long activityId, Integer source, Integer enableStatus,Map<Integer,String> actTypeMap);


    /**
     * 编辑活动计划时查询所有规格列表
     *
     * @return 规格列表
     */
    DubboResult<List<RspMaterialSpecificationDto>> getMsItemList();

    DubboResult<PageResultDto<RspActivityDto>> getPopularizePlanList(ReqActivityDto req,Map<Integer, String> actTypeMap);
    
    /**
     * 
     * 查询活动list 清除缓存用
     *
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<ActivityDto>> getActivityList();

    DubboResult<Integer> updateCron(ActivityDto activityDto);
}
