package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MaterialCtrDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @author liuqingsong
 * @createTime 2017/03/22
 */
@AdvancedFeignClient
public interface RemoteMaterialSpecificationService {

    /**
     * 查询某广告位下某活动的素材列表，按CTR排序
     *
     * @param slotId 广告位ID
     * @param activityId 活动ID
     * @param source 活动来源
     * @return CTR素材列表
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotActivity(Long slotId, Long activityId, Integer source);
    
    /**
     * 查询某广告位下某活动的素材列表，按CTR排序
     *
     * @param slotId 广告位ID
     * @return CTR素材列表
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotId(Long slotId);

    /**
     * 新素材曝光量达2000后更改状态
     *
     * @param materialId 素材ID
     * @return Boolean
     */
    DubboResult<Boolean> changeMsItemContentStatus(Long materialId);
}
