package cn.com.duiba.tuia.ssp.center.api.dto;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName: AccountChangeDto <br/>
 * date: 2016年12月6日 下午5:31:42 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 */
public class AccountChangeDto extends BaseDto {

    /**
     * @since JDK 1.6
     */
    private static final long serialVersionUID                   = 1872562288213960505L;

    /** 操作类型：0-增加余额 */
    public static final int   CHANGE_TYPE_ADD                    = 0;

    /** 操作类型：1-减少余额 */
    public static final int   CHANGE_TYPE_SUB                    = 1;

    /** 扣款范围大于或等于0 */
    public static final int   AMOUNT_SCALE_GREATER_THAN_OR_EQUAL = 0;

    /** 扣款范围小于0 */
    public static final int   AMOUNT_SCALE_LESS_THAN             = 1;

    /** 金额初始值 */
    public static final long  AMOUNT_INIT_VAL                    = 0;
    
    /**提现说明*/
    public static final String CASH_REMARK="提现";

    /** 媒体用户ID. */
    private Long              mediaId;

    /** 媒体账户结算表id. */
    private Long              settlementId;

    /** 结算月份. */
    private Date              curDate;

    /** 操作类型：0-增加余额，1-减少余额. */
    private Integer           changeType;

    /** 加款/扣款 金额 (分). */
    private Long              amount;

    /** 当前余额 (分). */
    private Long              balance;

    /** 备注. */
    private String            remark;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * settlementId.
     *
     * @return the settlementId
     * @since JDK 1.6
     */
    public Long getSettlementId() {
        return settlementId;
    }

    /**
     * settlementId.
     *
     * @param settlementId the settlementId to set
     * @since JDK 1.6
     */
    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public Date getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(Date curDate) {
        this.curDate = curDate;
    }

    /**
     * changeType.
     *
     * @return the changeType
     * @since JDK 1.6
     */
    public Integer getChangeType() {
        return changeType;
    }

    /**
     * changeType.
     *
     * @param changeType the changeType to set
     * @since JDK 1.6
     */
    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    /**
     * amount.
     *
     * @return the amount
     * @since JDK 1.6
     */
    public Long getAmount() {
        return amount;
    }

    /**
     * amount.
     *
     * @param amount the amount to set
     * @since JDK 1.6
     */
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    /**
     * balance.
     *
     * @return the balance
     * @since JDK 1.6
     */
    public Long getBalance() {
        return balance;
    }

    /**
     * balance.
     *
     * @param balance the balance to set
     * @since JDK 1.6
     */
    public void setBalance(Long balance) {
        this.balance = balance;
    }

    /**
     * remark.
     *
     * @return the remark
     * @since JDK 1.6
     */
    public String getRemark() {
        return remark;
    }

    /**
     * remark.
     *
     * @param remark the remark to set
     * @since JDK 1.6
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
