/**
 * Project Name:ssp-center-api
 * File Name:ReqMonthBill.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年5月7日下午10:36:50
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModelProperty;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMonthBill <br/>
 * Function: 月账单请求参数. <br/>
 * Date:     2017年5月7日 下午10:36:50 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public class ReqMonthBillDto extends BaseQueryDto {
    
    /**序列号*/
    private static final long serialVersionUID = 8515667938053417971L;
    
    /**媒体用户 ID*/
    @ApiModelProperty(value = "用户ID", required = true)
    private Long mediaId;
   
    /**查询时间(年-月)*/
    private String queryTime;

    /**
     * mediaId.
     *
     * @return the mediaId
     * @since JDK 1.6
     */
    public Long getMediaId() {
        return mediaId;
    }

    /**
     * mediaId.
     *
     * @param mediaId the mediaId to set
     * @since JDK 1.6
     */
    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }
    
    public String getQueryTime() {
        return queryTime;
    }

    
    public void setQueryTime(String queryTime) {
        this.queryTime = queryTime;
    }
    
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}

