/**
 * Project Name:ssp-center-api File Name:ReqUpdateMediaAccount.java Package Name:cn.com.duiba.tuia.ssp.center.api.dto
 * Date:2017年10月11日上午10:20:54 Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import io.swagger.annotations.ApiModelProperty;

/**
 * ClassName:ReqUpdateMediaAccount <br/>
 * Function: 修改媒体用户账号信息 <br/>
 * Date: 2017年10月11日 上午10:20:54 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
public class ReqUpdateMediaAccount implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = -8124738365696486373L;

    /** 媒体账号 */
    @ApiModelProperty(value = "mediaId", required = true)
    @NotNull(message = "媒体ID不能为空")
    private Long              mediaId;

    /** 线下打款 */
    @ApiModelProperty(value = "isOffline", required = false)
    private Integer           isOffline;

    /** 媒体账号类别 */
    @ApiModelProperty(value = "accountType", required = false)
    private Integer           accountType;

    /** 允许访问数据状态：0:关闭，1:开启 */
    @ApiModelProperty(value = "允许访问数据状态: 0:关闭，1:开启", required = false)
    private Integer           accessDataStatus;

    @ApiModelProperty(value = "数据展示时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private String            startDate;

    /** 媒体账号税率 */
    @ApiModelProperty(value = "taxRate", required = false)
    private Integer           taxRate;

    /** 是否是预付款账户 0不是 1是 */
    private Integer           prePayStatus;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Integer getIsOffline() {
        return isOffline;
    }

    public void setIsOffline(Integer isOffline) {
        this.isOffline = isOffline;
    }

    public Integer getAccountType() {
        return accountType;
    }

    public void setAccountType(Integer accountType) {
        this.accountType = accountType;
    }

    public Integer getAccessDataStatus() {
        return accessDataStatus;
    }

    public void setAccessDataStatus(Integer accessDataStatus) {
        this.accessDataStatus = accessDataStatus;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public Integer getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Integer taxRate) {
        this.taxRate = taxRate;
    }

    public Integer getPrePayStatus() {
        return prePayStatus;
    }

    public void setPrePayStatus(Integer prePayStatus) {
        this.prePayStatus = prePayStatus;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
