package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 激励规则对象
 */
@ApiModel
public class RewardStrategyDto implements Serializable {

    private static final long serialVersionUID = -4248762917522733769L;

    //规则主键id
    @ApiModelProperty(value = "ID", required = false)
    private Long id;

    //规则名称
    @ApiModelProperty(value = "规则名称", required = true)
    private String strategyName;

    //评分规则
    @ApiModelProperty(value = "评分规则", required = true)
    private GradeRule gradeRule;

    //奖励规则
    @ApiModelProperty(value = "奖励规则", required = true)
    private List<RewardRule> rewardRule;

    //媒体列表
    @ApiModelProperty(value = "媒体列表", required = false)
    private List<Long> mediaIds;


    //媒体列表
    @ApiModelProperty(value = "媒体ID列表,','隔开", required = false)
    private String mediaIdsStr;

    //规则描述
    @ApiModelProperty(value = "规则描述", required = true)
    private String strategyDesc;

    //当前月份（‘2017-11’）
    @ApiModelProperty(value = "当前月份（‘2017-11’）", required = true)
    private String curMonth;

    private Long copyId;

    private Date gmtCreate;

    private Date gmtModified;

    public String getMediaIdsStr() {
        return mediaIdsStr;
    }

    public void setMediaIdsStr(String mediaIdsStr) {
        this.mediaIdsStr = mediaIdsStr;
    }

    public List<Long> getMediaIds() {
        return mediaIds;
    }

    public void setMediaIds(List<Long> mediaIds) {
        this.mediaIds = mediaIds;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getStrategyDesc() {
        return strategyDesc;
    }

    public void setStrategyDesc(String strategyDesc) {
        this.strategyDesc = strategyDesc == null ? null : strategyDesc.trim();
    }

    public String getCurMonth() {
        return curMonth;
    }

    public void setCurMonth(String curMonth) {
        this.curMonth = curMonth == null ? null : curMonth.trim();
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getCopyId() {
        return copyId;
    }

    public void setCopyId(Long copyId) {
        this.copyId = copyId;
    }

    /**
     * 评级规则
     */
    @ApiModel
    public static class GradeRule implements Serializable {

        private static final long serialVersionUID = 2944621017272694759L;
        //质量分占比
        @ApiModelProperty(value = "质量分占比", required = true)
        private Double qualityRatio;
        //量级分占比
        @ApiModelProperty(value = "量级分占比", required = true)
        private Double levelRatio;
        //流量类型分占比
        @ApiModelProperty(value = "流量类型分占比", required = true)
        private Double flowRatio;

        @ApiModelProperty(value = "稳定性得分占比", required = true)
        private Double stableRatio;

        @ApiModelProperty(value = "真实性得分占比", required = true)
        private Double truthRatio;


        public Double getQualityRatio() {
            return qualityRatio;
        }

        public void setQualityRatio(Double qualityRatio) {
            this.qualityRatio = qualityRatio;
        }

        public Double getLevelRatio() {
            return levelRatio;
        }

        public void setLevelRatio(Double levelRatio) {
            this.levelRatio = levelRatio;
        }

        public Double getFlowRatio() {
            return flowRatio;
        }

        public void setFlowRatio(Double flowRatio) {
            this.flowRatio = flowRatio;
        }

        public Double getStableRatio() {
            return stableRatio;
        }

        public void setStableRatio(Double stableRatio) {
            this.stableRatio = stableRatio;
        }

        public Double getTruthRatio() {
            return truthRatio;
        }

        public void setTruthRatio(Double truthRatio) {
            this.truthRatio = truthRatio;
        }
    }

    /**
     * 奖励规则
     */
    @ApiModel
    public static class RewardRule implements Serializable {

        private static final long serialVersionUID = -8401738397671927130L;

        //分数（两位小数）
        @ApiModelProperty(value = "分数（两位小数）", required = true)
        private Double score;

        //奖励比例
        @ApiModelProperty(value = "奖励比例", required = true)
        private Double rewardRatio;

        public Double getScore() {
            return score;
        }

        public void setScore(Double score) {
            this.score = score;
        }

        public Double getRewardRatio() {
            return rewardRatio;
        }

        public void setRewardRatio(Double rewardRatio) {
            this.rewardRatio = rewardRatio;
        }
    }

    public GradeRule getGradeRule() {
        return gradeRule;
    }

    public void setGradeRule(GradeRule gradeRule) {
        this.gradeRule = gradeRule;
    }

    public List<RewardRule> getRewardRule() {
        return rewardRule;
    }

    public void setRewardRule(List<RewardRule> rewardRule) {
        this.rewardRule = rewardRule;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }
}
