package cn.com.duiba.tuia.ssp.center.api.remote;


import java.util.Date;
import java.util.List;

import org.springframework.web.bind.annotation.RequestMapping;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountMonthReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountMonthReportByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMonthBillDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SettledMonthReportRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.SettlementCashOrderDto;
import cn.com.duiba.tuia.ssp.center.api.dto.UpdateMonthReportDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteAccountReportMonthService {

    DubboResult<Integer> selectAmountByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<List<SettledMonthReportRsp>> selectListByPage(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    DubboResult<AccountMonthReportDto> selectMonthReportByReportId(Long reportId);

    DubboResult<List<SettledMonthReportRsp>> selectExportList(ReqAccountMonthReportByPage reqAccountMonthReportByPage);

    @RequestMapping("/updateMonthReportStatus2")
    DubboResult<Boolean> updateMonthReportStatus(Long appId, Date curDate,Integer settlementStatus);

    @RequestMapping("/updateMonthReportStatus1")
    DubboResult<Boolean> updateMonthReportStatus(UpdateMonthReportDto req);


    /**
     * 查询媒体所有可提现月账单
     * @param mediaId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByMediaId (Long mediaId);

    /**
     * 通过提现单查询月账单
     * @param cashOrderId
     * @return
     */
    DubboResult<List<AccountMonthReportDto>> selectByCashOrderId ( Long cashOrderId);
    
    /**
     * 
     * 查询用户下所有的月账单数据
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    
    DubboResult<List<AccountMonthReportDto>> selectAllMonthBillList(ReqMonthBillDto param);
    /**
     * 
     * 查询用户下所有的月账单总数
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> selectAllMonthBillCount(ReqMonthBillDto param);

    /**
     * 查询媒体下各个应用的每月的预计分成
     *
     * @param cashOrderId
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectBillByCashOrder(Long cashOrderId);
    
    /**
     * 查询已结算月账单
     *
     * @param monthBillId
     * @return
     * @since JDK 1.6
     */
    DubboResult<AccountMonthReportDto> selectSettledMonthBill(Long monthBillId);

    /**
     * 通过体现单查询对应的提现金额
     * 如果传入为null或长度为0的集合，则返回空的集合
     */
    DubboResult<List<SettlementCashOrderDto>> selectSettlementByCashOrderIds(List<Long> cashOrderIds);

    /**
     * 按月份和app id查询月账单信息
     */
    DubboResult<AccountMonthReportDto> selectByAppAndDate(Long appId,Date curDate);
    
    /**
     * 
     * 查询月账单结合通过ids. <br/>
     *
     * @author guyan
     * @param appIds
     * @param curDates
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthBillListByIds(List<Long> appIds,List<String> curDates,Long mediaId);
    
    /**
     * 
     * 查询月账单集合id. <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthBillListById(Long appId,String curDate,Long mediaId);

    /**
     * 
     * 查询月账单通过月账单类型. <br/>
     *
     * @author guyan
     * @param billType
     * @param cashOrderId
     * @param mediaId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> getMonthBillByType(Integer billType, Long cashOrderId,
                                     Long mediaId,List<Long> monthBillIds);
    
    /**
     * 
     * selectReportMonthSum <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<SettledMonthReportRsp> selectReportMonthSum(ReqAccountMonthReportByPage req);
    
    /**
     * 
     * updateCashRequirement:(更新请款清单). <br/>
     * 
     * @author guyan
     * @param cashOrderId
     * @return
     */
    DubboResult<Boolean> updateCashRequirement(Long cashOrderId);

    /**
     * updateMediaOperationName:(更新媒体运营姓名). <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param personName
     * @return
     */
    DubboResult<Boolean> updateMediaOperationName(Long appId, Date curDate,String mediaOperationName);
   
    /**
     * 
     * selectBillByCashOrderIds:(通过提现ids查询月账单). <br/>
     *
     * @author guyan
     * @param cashOrderId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AccountMonthReportDto>> selectMonthReportByCashOrderIds(List<Long> cashOrderIds);
    
    /**
     * 
     * updateRiskControlOperationName:(更新风控姓名). <br/>
     *
     * @author guyan
     * @param appId
     * @param curDate
     * @param riskControlOperationName
     * @return
     */
    DubboResult<Boolean> updateRiskControlOperationName(Long appId, Date curDate,String riskControlOperationName);
    
    List<AccountMonthReportDto> selectAllMonthBillByMediaId(ReqMonthBillDto param);
    
   List<AccountMonthReportDto> selectBillListByCreateMonth(ReqMonthBillDto param);

    /**
     * 查询媒体所有可提现月账单
     * @param mediaId
     * @param companyType
     * @return
     */
    List<AccountMonthReportDto> selectByMediaIdAndType(Long mediaId, Integer companyType);

    /**
     * 通过提现单查询对应的提现金额
     * 如果传入为null或长度为0的集合，则返回空的集合
     */
    List<SettlementCashOrderDto> selectSettlementAmountByCashOrderIds(List<Long> cashOrderIds);

    /**
     *
     * selectBillByCashOrderIds:(通过提现ids查询月账单). <br/>
     *
     * @author guyan
     * @param cashOrderIds
     * @return
     * @since JDK 1.6
     */
    List<AccountMonthReportDto> selectAllMonthReportByCashOrderIds(List<Long> cashOrderIds);
}
