/**
 * Project Name:ssp-center-api
 * File Name:RemoteBackDataService.java
 * Package Name:cn.com.duiba.tuia.ssp.center.api.remote
 * Date:2017年6月9日下午2:56:43
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.Date;
import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.BackDataDto;
import cn.com.duiba.tuia.ssp.center.api.dto.BackDataSumReqDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * ClassName:RemoteBackDataService <br/>
 * Function: 返回数据. <br/>
 * Date:     2017年6月9日 下午2:56:43 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteBackDataService {
	
	//媒体维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByAppIds(Date start, Date end, List<Long> ids, int entranceType);
	
	//活动维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActIds(Date start, Date end, List<Long> ids, int entranceType);
	
	//广告位活动维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayBySlotAct(Date startTime,Date endTime,Long slotId,List<Long> activityIds,Integer entranceType);
	
	//活动广告位维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActSlot(Date startTime,Date endTime,Long activityId,List<Long> slotIds, Integer entranceType);
	
	//活动媒体维度--获取浮标分日数据
	DubboResult<List<BackDataDto>> listDayByActApp(Date startTime,Date endTime,Long activityId,List<Long> appIds, Integer entranceType);
	

    /**
     * 根据广告位id列表查询返回发券数据--求和数据
     * @param start
     * @param end
     * @param entranceType
     * @return
     */
    DubboResult<BackDataDto> selectSumBackData(Date start, Date end, List<Long> slotIds, Integer entranceType);


    //每日数据

    /**
     *
     * @param start
     * @param end
     * @param slotId
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> selectBackDailyDataMapBySlotIds(Date start, Date end, Long slotId, Integer entranceType);

    //求和数据
    DubboResult<BackDataDto> newSelectAppBackSumData(Date startTime, Date endTime, List<Long> appIds,Integer entranceType);

    DubboResult<List<BackDataDto>> newSelectAppBackDailyList(Date start, Date end, Long appId,Integer entranceType);
    
    /**
     * 
     * newListDayBySlotIds:(广告位维度查询返回数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param ids
     * @param entranceType
     * @return
     */
    DubboResult<List<BackDataDto>> newListDayBySlotIds(Date start, Date end, List<Long> ids, int entranceType);
    
    /**
     * 
     * newSelectBackDataBySlotIds:(查询广告位维度返回数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param slotIds
     * @param entranceType
     * @return
     */
    
    DubboResult<List<BackDataDto>> newSelectBackDataBySlotIds (Date start, Date end, List<Long> slotIds, Integer entranceType);
    
    /**
     * 
     * newSelectBackDailyDataMapBySlotIds:(广告位维度返回每日数据). <br/>
     *
     * @author guyan
     * @param start
     * @param end
     * @param slotId
     * @param entranceType
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<BackDataDto>> newSelectBackDailyDataMapBySlotIds(Date start, Date end, Long slotId, Integer entranceType);

   
    DubboResult<List<BackDataDto>> newListDayByAppIds(Date start, Date end, List<Long> ids, int entranceType);
    
   
    DubboResult<List<BackDataDto>> newSelectAppBackDataList(Date startTime, Date endTime, List<Long> appIds,Integer entranceType);
    
    
    /**
     * 
     * selectAppSlotSumData:(媒体广告位求和). <br/>
     *
     * @author guyan
     * @param req
     * @return
     * @since JDK 1.6
     */
    DubboResult<BackDataDto> selectAppSlotSumData(BackDataSumReqDto req);
    
    

}


