package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * Created by xuefeng on 2018/4/18.
 */
@ApiModel
public class MediaAppInfoDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID", required = false)
    private Long id;

    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long mediaId;

    @ApiModelProperty(value = "应用Id", required = true)
    @NotNull(message = "应用Id不能为空")
    private Long appId;

    @ApiModelProperty(value = "媒体名称", required = true)
    @NotNull(message = "媒体名称不能为空")
    @Length(max = 20, message = "最大长度20")
    private String companyName;

    @ApiModelProperty(value = "媒体属性", required = true)
    @NotNull(message = "媒体属性不能为空")
    @Length(max = 20, message = "最大长度20")
    private String appProperty;

    @ApiModelProperty(value = "sdk对接", required = true)
    @NotNull(message = "sdk对接不能为空")
    @Length(max = 20, message = "最大长度20")
    private String sdk;

    @ApiModelProperty(value = "合作入口", required = true)
    @NotEmpty(message = "合作入口不能为空")
    private List<String> cooperateImgs;

    private String cooperateImg;

    @ApiModelProperty(value = "下载地址/wap网址", required = true)
    @NotNull(message = "下载地址/wap网址不能为空")
    private String wapUrl;

    @ApiModelProperty(value = "代理/直客", required = true)
    @NotNull(message = "代理/直客不能为空")
    @Length(max = 20, message = "最大长度20")
    private String accountType;

    @ApiModelProperty(value = "公司全称", required = true)
    @NotNull(message = "公司全称不能为空")
    @Length(max = 20, message = "最大长度20")
    private String companyFullName;

    @ApiModelProperty(value = "签订年框", required = true)
    @NotNull(message = "签订年框不能为空")
    @Length(max = 20, message = "最大长度20")
    private String signYearFrame;

    @ApiModelProperty(value = "线上/线下", required = true)
    @NotNull(message = "线上/线下不能为空")
    @Length(max = 20, message = "最大长度20")
    private String online;

    @ApiModelProperty(value = "测试合作模式", required = true)
    @NotNull(message = "测试合作模式不能为空")
    @Length(max = 20, message = "最大长度20")
    private String cooperateModel;

    @ApiModelProperty(value = "是否预付", required = true)
    @NotNull(message = "是否预付不能为空")
    @Length(max = 20, message = "最大长度20")
    private String prePay;

    @ApiModelProperty(value = "媒体收入预期", required = true)
    @NotNull(message = "媒体收入预期不能为空")
    @Length(max = 20, message = "最大长度20")
    private String expectedIncome;

    @ApiModelProperty(value = "数据情报：曝光", required = true)
    @Length(max = 20, message = "最大长度20")
    private String exposureData;

    @ApiModelProperty(value = "数据情报：点击", required = true)
    @Length(max = 20, message = "最大长度20")
    private String clickData;

    @ApiModelProperty(value = "数据情报：点击率", required = true)
    @Length(max = 20, message = "最大长度20")
    private String clickRate;

    @ApiModelProperty(value = "媒体能否及时反馈入口数据", required = true)
    @Length(max = 20, message = "最大长度20")
    private String feedBack;

    @ApiModelProperty(value = "历史广告主情报", required = true)
    @Length(max = 20, message = "最大长度20")
    private String history;

    @ApiModelProperty(value = "用户属性情报：媒体用户属性", required = true)
    @Length(max = 20, message = "最大长度20")
    private String userProperty;

    @ApiModelProperty(value = "其他情报", required = true)
    @Length(max = 20, message = "最大长度20")
    private String otherInfo;

    @ApiModelProperty(value = "媒体上线时间", required = true)
    @NotNull(message = "媒体上线时间不能为空")
    @Length(max = 20, message = "最大长度20")
    private String onlineTime;

    @ApiModelProperty(value = "投放素材要求", required = true)
    @NotNull(message = "投放素材要求不能为空")
    @Length(max = 20, message = "最大长度20")
    private String materialInfo;

    @ApiModelProperty(value = "媒体排斥竞品", required = true)
    @NotNull(message = "媒体排斥竞品不能为空")
    @Length(max = 20, message = "最大长度20")
    private String competeInfo;

    @ApiModelProperty(value = "媒体是否支持下载券", required = true)
    @NotNull(message = "媒体是否支持下载券不能为空")
    @Length(max = 20, message = "最大长度20")
    private String supportTicket;

    @ApiModelProperty(value = "特殊需求备注", required = true)
    @NotNull(message = "特殊需求备注不能为空")
    @Length(max = 20, message = "最大长度20")
    private String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getAppProperty() {
        return appProperty;
    }

    public void setAppProperty(String appProperty) {
        this.appProperty = appProperty;
    }

    public String getSdk() {
        return sdk;
    }

    public void setSdk(String sdk) {
        this.sdk = sdk;
    }

    public List<String> getCooperateImgs() {
        return cooperateImgs;
    }

    public void setCooperateImgs(List<String> cooperateImgs) {
        this.cooperateImgs = cooperateImgs;
    }

    public String getCooperateImg() {
        return cooperateImg;
    }

    public void setCooperateImg(String cooperateImg) {
        this.cooperateImg = cooperateImg;
    }

    public String getWapUrl() {
        return wapUrl;
    }

    public void setWapUrl(String wapUrl) {
        this.wapUrl = wapUrl;
    }

    public String getAccountType() {
        return accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getCompanyFullName() {
        return companyFullName;
    }

    public void setCompanyFullName(String companyFullName) {
        this.companyFullName = companyFullName;
    }

    public String getSignYearFrame() {
        return signYearFrame;
    }

    public void setSignYearFrame(String signYearFrame) {
        this.signYearFrame = signYearFrame;
    }

    public String getOnline() {
        return online;
    }

    public void setOnline(String online) {
        this.online = online;
    }

    public String getCooperateModel() {
        return cooperateModel;
    }

    public void setCooperateModel(String cooperateModel) {
        this.cooperateModel = cooperateModel;
    }

    public String getPrePay() {
        return prePay;
    }

    public void setPrePay(String prePay) {
        this.prePay = prePay;
    }

    public String getExpectedIncome() {
        return expectedIncome;
    }

    public void setExpectedIncome(String expectedIncome) {
        this.expectedIncome = expectedIncome;
    }

    public String getExposureData() {
        return exposureData;
    }

    public void setExposureData(String exposureData) {
        this.exposureData = exposureData;
    }

    public String getClickData() {
        return clickData;
    }

    public void setClickData(String clickData) {
        this.clickData = clickData;
    }

    public String getClickRate() {
        return clickRate;
    }

    public void setClickRate(String clickRate) {
        this.clickRate = clickRate;
    }

    public String getFeedBack() {
        return feedBack;
    }

    public void setFeedBack(String feedBack) {
        this.feedBack = feedBack;
    }

    public String getHistory() {
        return history;
    }

    public void setHistory(String history) {
        this.history = history;
    }

    public String getUserProperty() {
        return userProperty;
    }

    public void setUserProperty(String userProperty) {
        this.userProperty = userProperty;
    }

    public String getOtherInfo() {
        return otherInfo;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo;
    }

    public String getOnlineTime() {
        return onlineTime;
    }

    public void setOnlineTime(String onlineTime) {
        this.onlineTime = onlineTime;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public String getCompeteInfo() {
        return competeInfo;
    }

    public void setCompeteInfo(String competeInfo) {
        this.competeInfo = competeInfo;
    }

    public String getSupportTicket() {
        return supportTicket;
    }

    public void setSupportTicket(String supportTicket) {
        this.supportTicket = supportTicket;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
